/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.xdg;

import com.sun.deploy.xml.XMLNode;
import com.sun.javaws.xdg.MenuDatabase;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

class Menu {
    private String name;
    private Menu parent;
    private final ArrayList<Menu> subMenus = new ArrayList();
    private final ArrayList<String> entries = new ArrayList();

    Menu() {
    }

    Menu(Menu menu) {
        this();
        this.parent = menu;
        if (menu != null) {
            menu.addSubMenu(this);
        }
    }

    Menu(String string, Menu menu) {
        this(menu);
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    private String[] splitPath(String string) {
        String string2;
        String string3;
        int n;
        int n2 = n = string != null ? string.indexOf(47) : -1;
        if (n >= 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1, string.length());
        } else {
            string3 = string;
            string2 = null;
        }
        return new String[]{string3, string2};
    }

    Menu addMenuPath(String string) {
        String[] stringArray = this.splitPath(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Menu menu = this.getSubMenu(string2);
        if (menu == null) {
            menu = new Menu(string2, this);
        }
        if (string3 != null) {
            return menu.addMenuPath(string3);
        }
        return menu;
    }

    Menu getMenuPath(String string) {
        String[] stringArray = this.splitPath(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Menu menu = this.getSubMenu(string2);
        if (string3 != null && menu != null) {
            return menu.addMenuPath(string3);
        }
        return menu;
    }

    Menu getSubMenu(String string) {
        if (string == null) {
            return null;
        }
        for (Menu menu : this.subMenus) {
            if (menu == null || menu.name == null || !menu.name.equals(string)) continue;
            return menu;
        }
        return null;
    }

    void addSubMenu(Menu menu) {
        if (menu != null && !this.subMenus.contains(menu)) {
            this.subMenus.add(menu);
        }
    }

    void removeSubMenu(Menu menu) {
        this.subMenus.remove(menu);
        this.cleanupEmptyMenus();
    }

    void addEntry(String string) {
        if (string != null) {
            this.entries.add(string);
        }
    }

    void removeEntry(String string) {
        this.entries.remove(string);
        this.cleanupEmptyMenus();
    }

    private void cleanupEmptyMenus() {
        if (this.isEmpty() && this.parent != null && !MenuDatabase.isJavaWSMenu(this)) {
            this.parent.removeSubMenu(this);
        }
    }

    private boolean isEmpty() {
        return this.entries.isEmpty() && this.subMenus.isEmpty();
    }

    void write(Writer writer) throws IOException {
        writer.write("<Menu>\n");
        writer.write("<Name>" + this.name + "</Name>\n");
        for (Menu object : this.subMenus) {
            object.write(writer);
        }
        if (this.entries.size() > 0) {
            writer.write("<Include>\n");
            for (String string : this.entries) {
                writer.write("<Filename>" + string + "</Filename>\n");
            }
            writer.write("</Include>\n");
        }
        writer.write("</Menu>\n");
    }

    void read(XMLNode xMLNode) {
        for (XMLNode xMLNode2 = xMLNode.getNested(); xMLNode2 != null; xMLNode2 = xMLNode2.getNext()) {
            Menu menu;
            if (xMLNode2.getName().equals("Menu")) {
                menu = new Menu(this);
                menu.read(xMLNode2);
                this.addSubMenu(menu);
                continue;
            }
            if (xMLNode2.getName().equals("Name")) {
                menu = xMLNode2.getNested();
                this.name = menu != null ? menu.getName() : "";
                continue;
            }
            if (!xMLNode2.getName().equals("Include")) continue;
            for (menu = xMLNode2.getNested(); menu != null; menu = menu.getNext()) {
                XMLNode xMLNode3 = menu.getNested();
                this.addEntry(xMLNode3.getName());
            }
        }
    }
}

