/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;

public class CollapseUnaryTransformer
implements TreeTransformer {
    @Override
    public Tree transformTree(Tree tree) {
        if (tree.isPreTerminal() || tree.isLeaf()) {
            return tree.deepCopy();
        }
        Label label = tree.label().labelFactory().newLabel(tree.label());
        Tree[] children = tree.children();
        while (children.length == 1 && !children[0].isLeaf()) {
            children = children[0].children();
        }
        ArrayList<Tree> processedChildren = Generics.newArrayList();
        for (Tree child : children) {
            processedChildren.add(this.transformTree(child));
        }
        return tree.treeFactory().newTreeNode(label, processedChildren);
    }
}

