/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.AbstractStochasticCachingDiffFunction;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.Function;
import edu.stanford.nlp.optimization.StochasticMinimizer;
import edu.stanford.nlp.util.Pair;

public class InefficientSGDMinimizer<T extends Function>
extends StochasticMinimizer<T> {
    @Override
    public void shutUp() {
        this.quiet = true;
    }

    public void setBatchSize(int batchSize) {
        this.bSize = batchSize;
    }

    public InefficientSGDMinimizer() {
    }

    public InefficientSGDMinimizer(double SGDGain, int batchSize) {
        this(SGDGain, batchSize, 50);
    }

    public InefficientSGDMinimizer(double SGDGain, int batchSize, int passes) {
        this(SGDGain, batchSize, passes, Long.MAX_VALUE, false);
    }

    public InefficientSGDMinimizer(double SGDGain, int batchSize, int passes, boolean outputToFile) {
        this(SGDGain, batchSize, passes, Long.MAX_VALUE, outputToFile);
    }

    public InefficientSGDMinimizer(double SGDGain, int batchSize, int passes, long maxTime) {
        this(SGDGain, batchSize, passes, maxTime, false);
    }

    public InefficientSGDMinimizer(double SGDGain, int batchSize, int passes, long maxTime, boolean outputToFile) {
        this.bSize = batchSize;
        this.gain = SGDGain;
        this.numPasses = passes;
        this.outputIterationsToFile = outputToFile;
        this.maxTime = maxTime;
    }

    @Override
    protected String getName() {
        int g = (int)this.gain * 1000;
        return "SGD" + this.bSize + "_g" + g;
    }

    public Pair<Integer, Double> tune(Function function, double[] initial, long msPerTest, double gainLow, double gainHigh) {
        this.quiet = true;
        this.gain = this.tuneGain(function, initial, msPerTest, gainLow, gainHigh);
        this.bSize = this.tuneBatch(function, initial, msPerTest, 1);
        return new Pair<Integer, Double>(this.bSize, this.gain);
    }

    @Override
    public Pair<Integer, Double> tune(Function function, double[] initial, long msPerTest) {
        return this.tune(function, initial, msPerTest, 1.0E-7, 1.0);
    }

    @Override
    protected void takeStep(AbstractStochasticCachingDiffFunction dfunction) {
        for (int i = 0; i < this.x.length; ++i) {
            this.newX[i] = this.x[i] - this.gain * InefficientSGDMinimizer.gainSchedule(this.k, 5 * this.numBatches) * this.grad[i];
        }
    }

    public static void main(String[] args) {
        int dim = 500000;
        double maxVar = 5.0;
        final double[] var = new double[500000];
        double[] init = new double[500000];
        for (int i = 0; i < 500000; ++i) {
            init[i] = (double)(i + 1) / 500000.0 - 0.5;
            var[i] = 5.0 * (double)(i + 1) / 500000.0;
        }
        final double[] grads = new double[500000];
        DiffFunction f = new DiffFunction(){

            @Override
            public double[] derivativeAt(double[] x) {
                double val = Math.PI * this.valuePow(x, 2.141592653589793);
                for (int i = 0; i < 500000; ++i) {
                    grads[i] = x[i] * var[i] * val;
                }
                return grads;
            }

            @Override
            public double valueAt(double[] x) {
                return 1.0 + this.valuePow(x, Math.PI);
            }

            private double valuePow(double[] x, double pow) {
                double val = 0.0;
                for (int i = 0; i < 500000; ++i) {
                    val += x[i] * x[i] * var[i];
                }
                return Math.pow(val * 0.5, pow);
            }

            @Override
            public int domainDimension() {
                return 500000;
            }
        };
        InefficientSGDMinimizer min = new InefficientSGDMinimizer();
        min.minimize(f, 1.0E-4, init);
    }
}

