/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.util;

import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.FixedPrioritiesPriorityQueue;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class RelationTriple
implements Comparable<RelationTriple>,
Iterable<CoreLabel> {
    public final List<CoreLabel> subject;
    public final List<CoreLabel> relation;
    public final List<CoreLabel> object;
    private boolean istmod = false;
    private boolean prefixBe = false;
    private boolean suffixBe = false;
    private boolean suffixOf = false;
    public final double confidence;

    public RelationTriple(List<CoreLabel> subject, List<CoreLabel> relation, List<CoreLabel> object, double confidence) {
        this.subject = subject;
        this.relation = relation;
        this.object = object;
        this.confidence = confidence;
    }

    public RelationTriple(List<CoreLabel> subject, List<CoreLabel> relation, List<CoreLabel> object) {
        this(subject, relation, object, 1.0);
    }

    public List<CoreLabel> allTokens() {
        ArrayList<CoreLabel> allTokens = new ArrayList<CoreLabel>();
        allTokens.addAll(this.subject);
        allTokens.addAll(this.relation);
        allTokens.addAll(this.object);
        return allTokens;
    }

    public String subjectGloss() {
        return StringUtils.join(this.subject.stream().map(CoreLabel::word), " ");
    }

    public CoreLabel subjectHead() {
        return this.subject.get(this.subject.size() - 1);
    }

    public String subjectLemmaGloss() {
        return StringUtils.join(this.subject.stream().filter(x -> !x.tag().matches("[\\.\\?,:;'\"!]")).map(x -> x.lemma() == null ? x.word() : x.lemma()), " ");
    }

    public String objectGloss() {
        return StringUtils.join(this.object.stream().map(CoreLabel::word), " ");
    }

    public CoreLabel objectHead() {
        return this.object.get(this.object.size() - 1);
    }

    public String objectLemmaGloss() {
        return StringUtils.join(this.object.stream().filter(x -> !x.tag().matches("[\\.\\?,:;'\"!]")).map(x -> x.lemma() == null ? x.word() : x.lemma()), " ");
    }

    public String relationGloss() {
        String relationGloss = ((this.prefixBe ? "is " : "") + StringUtils.join(this.relation.stream().map(CoreLabel::word), " ") + (this.suffixBe ? " is" : "") + (this.suffixOf ? " of" : "") + (this.istmod ? " at_time" : "")).trim();
        if ("'s".equals(relationGloss)) {
            return "has";
        }
        return relationGloss;
    }

    public String relationLemmaGloss() {
        String relationGloss = ((this.prefixBe ? "be " : "") + StringUtils.join(this.relation.stream().filter(x -> !x.tag().matches("[\\.\\?,:;'\"!]") && (x.lemma() == null || !x.lemma().matches("[\\.,;'\"\\?!]"))).map(x -> x.lemma() == null ? x.word() : x.lemma()), " ").toLowerCase() + (this.suffixBe ? " be" : "") + (this.suffixOf ? " of" : "") + (this.istmod ? " at_time" : "")).trim();
        if ("'s".equals(relationGloss)) {
            return "have";
        }
        return relationGloss;
    }

    public String confidenceGloss() {
        return new DecimalFormat("0.000").format(this.confidence);
    }

    protected Pair<Integer, Integer> getSpan(List<CoreLabel> tokens, Function<CoreLabel, Integer> toMin, Function<CoreLabel, Integer> toMax) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (CoreLabel token : tokens) {
            min = Math.min(min, toMin.apply(token));
            max = Math.max(max, toMax.apply(token) + 1);
        }
        return Pair.makePair(min, max);
    }

    public Pair<Integer, Integer> subjectTokenSpan() {
        return this.getSpan(this.subject, x -> x.index() - 1, x -> x.index() - 1);
    }

    public Pair<Integer, Integer> relationTokenSpan() {
        if (this.relation.size() == 0) {
            return this.objectTokenSpan();
        }
        if (this.relation.size() == 1) {
            return Pair.makePair(this.relation.get(0).index() - 1, this.relation.get(0).index());
        }
        int longestChunk = 0;
        int longestChunkStart = 0;
        int lastIndex = this.relation.get(0).index() - 1;
        int thisChunk = 1;
        int thisChunkStart = 0;
        for (int i = 1; i < this.relation.size(); ++i) {
            CoreLabel token = this.relation.get(i);
            if (token.index() - 1 == lastIndex + 1) {
                ++thisChunk;
                continue;
            }
            if (thisChunk > longestChunk) {
                longestChunk = thisChunk;
                longestChunkStart = thisChunkStart;
            }
            thisChunkStart = i;
            thisChunk = 1;
        }
        if (thisChunk > longestChunk) {
            longestChunk = thisChunk;
            longestChunkStart = thisChunkStart;
        }
        return Pair.makePair(this.relation.get(longestChunkStart).index() - 1, this.relation.get(longestChunkStart + longestChunk - 1).index());
    }

    public Pair<Integer, Integer> objectTokenSpan() {
        return this.getSpan(this.object, x -> x.index() - 1, x -> x.index() - 1);
    }

    public boolean isPrefixBe() {
        return this.prefixBe;
    }

    public boolean isPrefixBe(boolean newValue) {
        boolean oldValue = this.prefixBe;
        this.prefixBe = newValue;
        return oldValue;
    }

    public boolean isSuffixBe() {
        return this.suffixBe;
    }

    public boolean isSuffixBe(boolean newValue) {
        boolean oldValue = this.suffixBe;
        this.suffixBe = newValue;
        return oldValue;
    }

    public boolean isSuffixOf() {
        return this.suffixOf;
    }

    public boolean isSuffixOf(boolean newValue) {
        boolean oldValue = this.suffixOf;
        this.suffixOf = newValue;
        return oldValue;
    }

    public boolean istmod() {
        return this.istmod;
    }

    public boolean istmod(boolean newValue) {
        boolean oldValue = this.istmod;
        this.istmod = newValue;
        return oldValue;
    }

    public Optional<SemanticGraph> asDependencyTree() {
        return Optional.empty();
    }

    public List<CoreLabel> asSentence() {
        FixedPrioritiesPriorityQueue<CoreLabel> orderedSentence = new FixedPrioritiesPriorityQueue<CoreLabel>();
        double defaultIndex = 0.0;
        for (CoreLabel token : this.subject) {
            orderedSentence.add(token, token.index() >= 0 ? (double)(-token.index()) : -defaultIndex);
            defaultIndex += 1.0;
        }
        for (CoreLabel token : this.relation) {
            orderedSentence.add(token, token.index() >= 0 ? (double)(-token.index()) : -defaultIndex);
            defaultIndex += 1.0;
        }
        for (CoreLabel token : this.object) {
            orderedSentence.add(token, token.index() >= 0 ? (double)(-token.index()) : -defaultIndex);
            defaultIndex += 1.0;
        }
        return orderedSentence.toSortedList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationTriple)) {
            return false;
        }
        RelationTriple that = (RelationTriple)o;
        return this.object.equals(that.object) && this.relation.equals(that.relation) && this.subject.equals(that.subject);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "" + this.confidence + "\t" + this.subjectGloss() + "\t" + this.relationGloss() + "\t" + this.objectGloss();
    }

    public String toReverbString(String docid, CoreMap sentence) {
        return (docid == null ? "no_doc_id" : docid) + "\t" + this.relation.get(0).sentIndex() + "\t" + this.subjectGloss().replace('\t', ' ') + "\t" + this.relationGloss().replace('\t', ' ') + "\t" + this.objectGloss().replace('\t', ' ') + "\t" + (this.subject.get(0).index() - 1) + "\t" + this.subject.get(this.subject.size() - 1).index() + "\t" + (this.relation.get(0).index() - 1) + "\t" + this.relation.get(this.relation.size() - 1).index() + "\t" + (this.object.get(0).index() - 1) + "\t" + this.object.get(this.object.size() - 1).index() + "\t" + this.confidenceGloss() + "\t" + StringUtils.join(((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).stream().map(x -> x.word().replace('\t', ' ').replace(" ", "")), " ") + "\t" + StringUtils.join(((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).stream().map(CoreLabel::tag), " ") + "\t" + this.subjectLemmaGloss().replace('\t', ' ') + "\t" + this.relationLemmaGloss().replace('\t', ' ') + "\t" + this.objectLemmaGloss().replace('\t', ' ');
    }

    @Override
    public int compareTo(RelationTriple o) {
        if (this.confidence < o.confidence) {
            return -1;
        }
        if (this.confidence > o.confidence) {
            return 1;
        }
        return 0;
    }

    @Override
    public Iterator<CoreLabel> iterator() {
        return CollectionUtils.concatIterators(this.subject.iterator(), this.relation.iterator(), this.object.iterator());
    }

    public static class WithTree
    extends RelationTriple {
        public final SemanticGraph sourceTree;

        public WithTree(List<CoreLabel> subject, List<CoreLabel> relation, List<CoreLabel> object, SemanticGraph tree, double confidence) {
            super(subject, relation, object, confidence);
            this.sourceTree = new SemanticGraph(tree);
        }

        @Override
        public CoreLabel subjectHead() {
            if (this.subject.size() == 1) {
                return (CoreLabel)this.subject.get(0);
            }
            Span subjectSpan = Span.fromValues(((CoreLabel)this.subject.get(0)).index(), ((CoreLabel)this.subject.get(this.subject.size() - 1)).index());
            for (int i = this.subject.size() - 1; i >= 0; --i) {
                for (SemanticGraphEdge edge : this.sourceTree.incomingEdgeIterable(new IndexedWord((CoreLabel)this.subject.get(i)))) {
                    if (edge.getGovernor().index() >= subjectSpan.start() && edge.getGovernor().index() < subjectSpan.end()) continue;
                    return (CoreLabel)this.subject.get(i);
                }
            }
            return (CoreLabel)this.subject.get(this.subject.size() - 1);
        }

        @Override
        public CoreLabel objectHead() {
            if (this.object.size() == 1) {
                return (CoreLabel)this.object.get(0);
            }
            Span objectSpan = Span.fromValues(((CoreLabel)this.object.get(0)).index(), ((CoreLabel)this.object.get(this.object.size() - 1)).index());
            for (int i = this.object.size() - 1; i >= 0; --i) {
                for (SemanticGraphEdge edge : this.sourceTree.incomingEdgeIterable(new IndexedWord((CoreLabel)this.object.get(i)))) {
                    if (edge.getGovernor().index() >= objectSpan.start() && edge.getGovernor().index() < objectSpan.end()) continue;
                    return (CoreLabel)this.object.get(i);
                }
            }
            return (CoreLabel)this.object.get(this.object.size() - 1);
        }

        @Override
        public Optional<SemanticGraph> asDependencyTree() {
            return Optional.of(this.sourceTree);
        }
    }
}

