/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.optimization.CmdEvaluator;
import edu.stanford.nlp.stats.MultiClassChunkEvalStats;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Triple;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;

public class CRFClassifierEvaluator<IN extends CoreMap>
extends CmdEvaluator {
    private CRFClassifier<IN> classifier;
    private String cmdStr = "/u/nlp/bin/conlleval -r";
    private String[] cmd;
    Collection<List<IN>> data;
    List<Triple<int[][][], int[], double[][][]>> featurizedData;

    public CRFClassifierEvaluator(String description, CRFClassifier<IN> classifier, Collection<List<IN>> data, List<Triple<int[][][], int[], double[][][]>> featurizedData) {
        this.description = description;
        this.classifier = classifier;
        this.data = data;
        this.featurizedData = featurizedData;
        this.cmd = CRFClassifierEvaluator.getCmd(this.cmdStr);
        this.saveOutput = true;
    }

    public CRFClassifierEvaluator(String description, CRFClassifier<IN> classifier) {
        this.description = description;
        this.classifier = classifier;
        this.saveOutput = true;
    }

    public void setTestData(Collection<List<IN>> data, List<Triple<int[][][], int[], double[][][]>> featurizedData) {
        this.data = data;
        this.featurizedData = featurizedData;
    }

    public void setEvalCmd(String evalCmd) {
        System.err.println("setEvalCmd to " + evalCmd);
        this.cmdStr = evalCmd;
        if (this.cmdStr != null) {
            this.cmdStr = this.cmdStr.trim();
            if (this.cmdStr.isEmpty()) {
                this.cmdStr = null;
            }
        }
        this.cmd = CRFClassifierEvaluator.getCmd(this.cmdStr);
    }

    @Override
    public void setValues(double[] x) {
        this.classifier.updateWeightsForTest(x);
    }

    @Override
    public String[] getCmd() {
        return this.cmd;
    }

    private double interpretCmdOutput() {
        int fScoreIndex;
        String output = this.getOutput();
        String[] parts = output.split("\\s+");
        for (fScoreIndex = 0; fScoreIndex < parts.length && !parts[fScoreIndex].equals("FB1:"); ++fScoreIndex) {
        }
        if (++fScoreIndex < parts.length) {
            return Double.parseDouble(parts[fScoreIndex]);
        }
        System.err.println("ERROR in CRFClassifierEvaluator.interpretCmdOutput(), cannot find FB1 score in output:\n" + output);
        return -1.0;
    }

    @Override
    public void outputToCmd(OutputStream outputStream) {
        try {
            PrintWriter pw = IOUtils.encodedOutputStreamPrintWriter(outputStream, null, true);
            this.classifier.classifyAndWriteAnswers(this.data, this.featurizedData, pw, this.classifier.makeReaderAndWriter());
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    @Override
    public double evaluate(double[] x) {
        double score;
        this.setValues(x);
        if (this.getCmd() != null) {
            this.evaluateCmd(this.getCmd());
            score = this.interpretCmdOutput();
        } else {
            try {
                File f = File.createTempFile("CRFClassifierEvaluator", "txt");
                f.deleteOnExit();
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(f));
                PrintWriter pw = IOUtils.encodedOutputStreamPrintWriter(outputStream, null, true);
                this.classifier.classifyAndWriteAnswers(this.data, this.featurizedData, pw, this.classifier.makeReaderAndWriter());
                ((OutputStream)outputStream).close();
                BufferedReader br = new BufferedReader(new FileReader(f));
                MultiClassChunkEvalStats stats = new MultiClassChunkEvalStats("O");
                score = stats.score(br, "\t");
                System.err.println(stats.getConllEvalString());
                f.delete();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return score;
    }
}

