/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleProvides
implements Cloneable,
Node {
    private final int provides_index;
    private final int provides_with_count;
    private final int[] provides_with_index;

    ModuleProvides(DataInput file) throws IOException {
        this.provides_index = file.readUnsignedShort();
        this.provides_with_count = file.readUnsignedShort();
        this.provides_with_index = new int[this.provides_with_count];
        for (int i = 0; i < this.provides_with_count; ++i) {
            this.provides_with_index[i] = file.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleProvides(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.provides_index);
        file.writeShort(this.provides_with_count);
        for (int entry : this.provides_with_index) {
            file.writeShort(entry);
        }
    }

    public String toString() {
        return "provides(" + this.provides_index + ", " + this.provides_with_count + ", ...)";
    }

    public String toString(ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String interface_name = constant_pool.constantToString(this.provides_index, (byte)7);
        buf.append(Utility.compactClassName(interface_name, false));
        buf.append(", with(").append(this.provides_with_count).append("):\n");
        for (int index : this.provides_with_index) {
            String class_name = constant_pool.getConstantString(index, (byte)7);
            buf.append("      ").append(Utility.compactClassName(class_name, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    public ModuleProvides copy() {
        try {
            return (ModuleProvides)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

