/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModulePackages
extends Attribute {
    private int[] package_index_table;

    public ModulePackages(ModulePackages c) {
        this(c.getNameIndex(), c.getLength(), c.getPackageIndexTable(), c.getConstantPool());
    }

    public ModulePackages(int name_index, int length, int[] package_index_table, ConstantPool constant_pool) {
        super((byte)23, name_index, length, constant_pool);
        this.package_index_table = package_index_table != null ? package_index_table : new int[]{};
    }

    ModulePackages(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (int[])null, constant_pool);
        int number_of_packages = input.readUnsignedShort();
        this.package_index_table = new int[number_of_packages];
        for (int i = 0; i < number_of_packages; ++i) {
            this.package_index_table[i] = input.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModulePackages(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.package_index_table.length);
        for (int index : this.package_index_table) {
            file.writeShort(index);
        }
    }

    public int[] getPackageIndexTable() {
        return this.package_index_table;
    }

    public int getNumberOfPackages() {
        return this.package_index_table == null ? 0 : this.package_index_table.length;
    }

    public String[] getPackageNames() {
        String[] names = new String[this.package_index_table.length];
        for (int i = 0; i < this.package_index_table.length; ++i) {
            names[i] = super.getConstantPool().getConstantString(this.package_index_table[i], (byte)20).replace('/', '.');
        }
        return names;
    }

    public void setPackageIndexTable(int[] package_index_table) {
        this.package_index_table = package_index_table != null ? package_index_table : new int[]{};
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ModulePackages(");
        buf.append(this.package_index_table.length);
        buf.append("):\n");
        for (int index : this.package_index_table) {
            String package_name = super.getConstantPool().getConstantString(index, (byte)20);
            buf.append("  ").append(Utility.compactClassName(package_name, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        ModulePackages c = (ModulePackages)this.clone();
        if (this.package_index_table != null) {
            c.package_index_table = new int[this.package_index_table.length];
            System.arraycopy(this.package_index_table, 0, c.package_index_table, 0, this.package_index_table.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

