/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.Data;
import edu.stanford.nlp.patterns.surface.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.surface.ScorePatterns;
import edu.stanford.nlp.patterns.surface.ScorePhrases;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.Execution;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class ScorePatternsRatioModifiedFreq
extends ScorePatterns {
    private TwoDimensionalCounter<String, ConstantsAndVariables.ScorePhraseMeasures> phInPatScores;
    private ScorePhrases scorePhrases;

    public ScorePatternsRatioModifiedFreq(ConstantsAndVariables constVars, GetPatternsFromDataMultiClass.PatternScoring patternScoring, String label, TwoDimensionalCounter<SurfacePattern, String> patternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> negPatternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> unLabeledPatternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> negandUnLabeledPatternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> allPatternsandWords4Label, TwoDimensionalCounter<String, ConstantsAndVariables.ScorePhraseMeasures> phInPatScores, ScorePhrases scorePhrases, Properties props) {
        super(constVars, patternScoring, label, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, negandUnLabeledPatternsandWords4Label, allPatternsandWords4Label, props);
        this.phInPatScores = phInPatScores;
        this.scorePhrases = scorePhrases;
    }

    @Override
    public void setUp(Properties props) {
    }

    @Override
    Counter<SurfacePattern> score() throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Counter<String> externalWordWeightsNormalized = null;
        if (this.constVars.dictOddsWeights.containsKey(this.label)) {
            externalWordWeightsNormalized = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(this.constVars.dictOddsWeights.get(this.label), true, true, false);
        }
        ClassicCounter<SurfacePattern> currentPatternWeights4Label = new ClassicCounter();
        boolean useFreqPhraseExtractedByPat = false;
        if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.SqrtAllRatio)) {
            useFreqPhraseExtractedByPat = true;
        }
        Counter<SurfacePattern> numeratorPatWt = this.convert2OneDim(this.label, this.patternsandWords4Label, this.constVars.sqrtPatScore, false, null, useFreqPhraseExtractedByPat);
        Counter<SurfacePattern> denominatorPatWt = null;
        if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PosNegUnlabOdds)) {
            denominatorPatWt = this.convert2OneDim(this.label, this.negandUnLabeledPatternsandWords4Label, this.constVars.sqrtPatScore, false, externalWordWeightsNormalized, useFreqPhraseExtractedByPat);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.RatioAll)) {
            denominatorPatWt = this.convert2OneDim(this.label, this.allPatternsandWords4Label, this.constVars.sqrtPatScore, false, externalWordWeightsNormalized, useFreqPhraseExtractedByPat);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PosNegOdds)) {
            denominatorPatWt = this.convert2OneDim(this.label, this.negPatternsandWords4Label, this.constVars.sqrtPatScore, false, externalWordWeightsNormalized, useFreqPhraseExtractedByPat);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPat) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPatLogP) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREG) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREGlogP)) {
            denominatorPatWt = this.convert2OneDim(this.label, this.negandUnLabeledPatternsandWords4Label, this.constVars.sqrtPatScore, true, externalWordWeightsNormalized, useFreqPhraseExtractedByPat);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.SqrtAllRatio)) {
            denominatorPatWt = this.convert2OneDim(this.label, this.negandUnLabeledPatternsandWords4Label, true, false, externalWordWeightsNormalized, useFreqPhraseExtractedByPat);
        } else {
            throw new RuntimeException("Cannot understand patterns scoring");
        }
        currentPatternWeights4Label = Counters.divisionNonNaN(numeratorPatWt, denominatorPatWt);
        if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPatLogP) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREGlogP)) {
            ClassicCounter logpos_i = new ClassicCounter();
            for (Map.Entry en : this.patternsandWords4Label.entrySet()) {
                logpos_i.setCount(en.getKey(), Math.log(en.getValue().size()));
            }
            Counters.multiplyInPlace(currentPatternWeights4Label, logpos_i);
        }
        Counters.retainNonZeros(currentPatternWeights4Label);
        return currentPatternWeights4Label;
    }

    Counter<SurfacePattern> convert2OneDim(String label, TwoDimensionalCounter<SurfacePattern, String> patternsandWords, boolean sqrtPatScore, boolean scorePhrasesInPatSelection, Counter<String> dictOddsWordWeights, boolean useFreqPhraseExtractedByPat) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        if (Data.googleNGram.size() == 0 && Data.googleNGramsFile != null) {
            Data.loadGoogleNGrams();
        }
        ClassicCounter<SurfacePattern> patterns = new ClassicCounter<SurfacePattern>();
        Counter<String> googleNgramNormScores = new ClassicCounter<String>();
        Counter<String> domainNgramNormScores = new ClassicCounter<String>();
        Counter<String> externalFeatWtsNormalized = new ClassicCounter<String>();
        ClassicCounter<String> editDistanceFromOtherSemanticBinaryScores = new ClassicCounter<String>();
        ClassicCounter<String> editDistanceFromAlreadyExtractedBinaryScores = new ClassicCounter<String>();
        double externalWtsDefault = 0.5;
        Counter<String> classifierScores = null;
        if ((this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPat) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPatLogP)) && scorePhrasesInPatSelection) {
            HashSet<String> allPhrasesInQuestion = new HashSet<String>();
            for (Map.Entry<SurfacePattern, ClassicCounter<String>> d : patternsandWords.entrySet()) {
                allPhrasesInQuestion.addAll(d.getValue().keySet());
            }
            for (String g : allPhrasesInQuestion) {
                if (this.constVars.usePatternEvalEditDistOther) {
                    editDistanceFromOtherSemanticBinaryScores.setCount(g, this.constVars.getEditDistanceScoresOtherClassThreshold(g));
                }
                if (this.constVars.usePatternEvalEditDistSame) {
                    editDistanceFromAlreadyExtractedBinaryScores.setCount(g, 1.0 - this.constVars.getEditDistanceScoresThisClassThreshold(label, g));
                }
                if (this.constVars.usePatternEvalGoogleNgram && Data.googleNGram.containsKey(g)) {
                    assert (Data.rawFreq.containsKey(g));
                    googleNgramNormScores.setCount(g, (1.0 + Data.rawFreq.getCount(g) * Math.sqrt(Data.ratioGoogleNgramFreqWithDataFreq)) / Data.googleNGram.getCount(g));
                }
                if (this.constVars.usePatternEvalDomainNgram && Data.domainNGramRawFreq.containsKey(g)) {
                    assert (Data.rawFreq.containsKey(g));
                    domainNgramNormScores.setCount(g, this.scorePhrases.phraseScorer.getDomainNgramScore(g));
                }
                if (!this.constVars.usePatternEvalWordClass) continue;
                Integer num = this.constVars.getWordClassClusters().get(g);
                if (num != null && this.constVars.distSimWeights.get(label).containsKey(num)) {
                    externalFeatWtsNormalized.setCount(g, this.constVars.distSimWeights.get(label).getCount(num));
                    continue;
                }
                externalFeatWtsNormalized.setCount(g, externalWtsDefault);
            }
            if (this.constVars.usePatternEvalGoogleNgram) {
                googleNgramNormScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(googleNgramNormScores, true, true, false);
            }
            if (this.constVars.usePatternEvalDomainNgram) {
                domainNgramNormScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(domainNgramNormScores, true, true, false);
            }
            if (this.constVars.usePatternEvalWordClass) {
                externalFeatWtsNormalized = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(externalFeatWtsNormalized, true, true, false);
            }
        } else if ((this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREG) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREGlogP)) && scorePhrasesInPatSelection) {
            Properties props2 = new Properties();
            props2.putAll((Map<?, ?>)this.props);
            props2.setProperty("phraseScorerClass", "edu.stanford.nlp.patterns.surface.ScorePhrasesLearnFeatWt");
            ScorePhrases scoreclassifier = new ScorePhrases(props2, this.constVars);
            System.out.println("file is " + this.props.getProperty("domainNGramsFile"));
            Execution.fillOptions(Data.class, props2);
            classifierScores = scoreclassifier.phraseScorer.scorePhrases(label, patternsandWords.secondKeySet(), true);
        }
        ClassicCounter<String> cachedScoresForThisIter = new ClassicCounter<String>();
        for (Map.Entry<SurfacePattern, ClassicCounter<String>> d : patternsandWords.entrySet()) {
            for (Map.Entry<String, Double> e : d.getValue().entrySet()) {
                String word = e.getKey();
                ClassicCounter<ConstantsAndVariables.ScorePhraseMeasures> scoreslist = new ClassicCounter<ConstantsAndVariables.ScorePhraseMeasures>();
                double score = 1.0;
                if ((this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPat) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPatLogP)) && scorePhrasesInPatSelection) {
                    if (cachedScoresForThisIter.containsKey(word)) {
                        score = cachedScoresForThisIter.getCount(word);
                    } else {
                        if (this.constVars.getOtherSemanticClasses().contains(word) || this.constVars.getCommonEngWords().contains(word)) {
                            score = 1.0;
                        } else {
                            if (this.constVars.usePatternEvalSemanticOdds) {
                                double semanticClassOdds = 1.0;
                                if (dictOddsWordWeights.containsKey(word)) {
                                    semanticClassOdds = 1.0 - dictOddsWordWeights.getCount(word);
                                }
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.SEMANTICODDS, semanticClassOdds);
                            }
                            if (this.constVars.usePatternEvalGoogleNgram) {
                                double gscore = 0.0;
                                if (googleNgramNormScores.containsKey(word)) {
                                    gscore = 1.0 - googleNgramNormScores.getCount(word);
                                }
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.GOOGLENGRAM, gscore);
                            }
                            if (this.constVars.usePatternEvalDomainNgram) {
                                double domainscore = domainNgramNormScores.containsKey(word) ? 1.0 - domainNgramNormScores.getCount(word) : 1.0 - this.scorePhrases.phraseScorer.getPhraseWeightFromWords(domainNgramNormScores, word, this.scorePhrases.phraseScorer.OOVDomainNgramScore);
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.DOMAINNGRAM, domainscore);
                            }
                            if (this.constVars.usePatternEvalWordClass) {
                                double externalFeatureWt = externalWtsDefault;
                                if (externalFeatWtsNormalized.containsKey(e.getKey())) {
                                    externalFeatureWt = 1.0 - externalFeatWtsNormalized.getCount(e.getKey());
                                }
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.DISTSIM, externalFeatureWt);
                            }
                            if (this.constVars.usePatternEvalEditDistOther) {
                                assert (editDistanceFromOtherSemanticBinaryScores.containsKey(e.getKey())) : "How come no edit distance info?";
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.EDITDISTOTHER, editDistanceFromOtherSemanticBinaryScores.getCount(e.getKey()));
                            }
                            if (this.constVars.usePatternEvalEditDistSame) {
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.EDITDISTSAME, editDistanceFromAlreadyExtractedBinaryScores.getCount(e.getKey()));
                            }
                            score = Counters.mean(scoreslist);
                            this.phInPatScores.setCounter(e.getKey(), scoreslist);
                        }
                        cachedScoresForThisIter.setCount(e.getKey(), score);
                    }
                } else if ((this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREG) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREGlogP)) && scorePhrasesInPatSelection) {
                    score = 1.0 - classifierScores.getCount(e.getKey());
                }
                if (useFreqPhraseExtractedByPat) {
                    score *= e.getValue().doubleValue();
                }
                if (this.constVars.sqrtPatScore) {
                    patterns.incrementCount(d.getKey(), Math.sqrt(score));
                    continue;
                }
                patterns.incrementCount(d.getKey(), score);
            }
        }
        return patterns;
    }
}

