/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.surface.AnnotatedTextReader;
import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.CreatePatterns;
import edu.stanford.nlp.patterns.surface.Data;
import edu.stanford.nlp.patterns.surface.InvertedIndexByTokens;
import edu.stanford.nlp.patterns.surface.LearnImportantFeatures;
import edu.stanford.nlp.patterns.surface.PatternsAnnotations;
import edu.stanford.nlp.patterns.surface.ScorePatterns;
import edu.stanford.nlp.patterns.surface.ScorePatternsF1;
import edu.stanford.nlp.patterns.surface.ScorePatternsFreqBased;
import edu.stanford.nlp.patterns.surface.ScorePatternsRatioModifiedFreq;
import edu.stanford.nlp.patterns.surface.ScorePhrases;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.EditDistance;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PriorityQueue;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.TypesafeMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class GetPatternsFromDataMultiClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>> patternsForEachToken = null;
    public Map<String, Set<String>> wordsForOtherClass = null;
    Map<String, Boolean> writtenPatInJustification = new HashMap<String, Boolean>();
    Map<String, Counter<SurfacePattern>> learnedPatterns = new HashMap<String, Counter<SurfacePattern>>();
    Map<String, Counter<String>> learnedWords = new HashMap<String, Counter<String>>();
    public Map<String, TwoDimensionalCounter<String, SurfacePattern>> wordsPatExtracted = new HashMap<String, TwoDimensionalCounter<String, SurfacePattern>>();
    Properties props;
    public ScorePhrases scorePhrases;
    public ConstantsAndVariables constVars = new ConstantsAndVariables();
    public CreatePatterns createPats;
    DecimalFormat df = new DecimalFormat("#.##");
    static StanfordCoreNLP pipeline = null;
    public Map<String, TwoDimensionalCounter<SurfacePattern, String>> patternsandWords = null;
    public Map<String, TwoDimensionalCounter<SurfacePattern, String>> allPatternsandWords = null;
    public Map<String, Counter<SurfacePattern>> currentPatternWeights = null;
    public TwoDimensionalCounter<String, ConstantsAndVariables.ScorePhraseMeasures> phInPatScoresCache = new TwoDimensionalCounter();

    public GetPatternsFromDataMultiClass(Properties props, Map<String, List<CoreLabel>> sents, Set<String> seedSet, boolean labelUsingSeedSets, String answerLabel) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this(props, sents, seedSet, labelUsingSeedSets, PatternsAnnotations.PatternLabel1.class, answerLabel);
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, List<CoreLabel>> sents, Set<String> seedSet, boolean labelUsingSeedSets, Class answerClass, String answerLabel) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this.props = props;
        HashMap<String, Class<? extends TypesafeMap.Key<String>>> ansCl = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
        ansCl.put(answerLabel, answerClass);
        HashMap<String, Class> generalizeClasses = new HashMap<String, Class>();
        HashMap<String, Map<Class, Object>> ignoreClasses = new HashMap<String, Map<Class, Object>>();
        ignoreClasses.put(answerLabel, new HashMap());
        HashMap<String, Set<String>> seedSets = new HashMap<String, Set<String>>();
        seedSets.put(answerLabel, seedSet);
        this.setUpConstructor(sents, seedSets, labelUsingSeedSets, ansCl, generalizeClasses, ignoreClasses);
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, List<CoreLabel>> sents, Set<String> seedSet, boolean labelUsingSeedSets, String answerLabel, Map<String, Class> generalizeClasses, Map<Class, Object> ignoreClasses) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this(props, sents, seedSet, labelUsingSeedSets, PatternsAnnotations.PatternLabel1.class, answerLabel, generalizeClasses, ignoreClasses);
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, List<CoreLabel>> sents, Set<String> seedSet, boolean labelUsingSeedSets, Class answerClass, String answerLabel, Map<String, Class> generalizeClasses, Map<Class, Object> ignoreClasses) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this.props = props;
        HashMap<String, Class<? extends TypesafeMap.Key<String>>> ansCl = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
        ansCl.put(answerLabel, answerClass);
        HashMap<String, Map<Class, Object>> iC = new HashMap<String, Map<Class, Object>>();
        iC.put(answerLabel, ignoreClasses);
        HashMap<String, Set<String>> seedSets = new HashMap<String, Set<String>>();
        seedSets.put(answerLabel, seedSet);
        this.setUpConstructor(sents, seedSets, labelUsingSeedSets, ansCl, generalizeClasses, iC);
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, List<CoreLabel>> sents, Map<String, Set<String>> seedSets, boolean labelUsingSeedSets) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, InterruptedException, ExecutionException {
        this.props = props;
        HashMap<String, Class<? extends TypesafeMap.Key<String>>> ansCl = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
        HashMap<String, Class> gC = new HashMap<String, Class>();
        HashMap<String, Map<Class, Object>> iC = new HashMap<String, Map<Class, Object>>();
        int i = 1;
        for (String label : seedSets.keySet()) {
            String ansclstr = "edu.stanford.nlp.patterns.surface.PatternsAnnotations$PatternLabel" + i;
            ansCl.put(label, Class.forName(ansclstr));
            iC.put(label, new HashMap());
            ++i;
        }
        this.setUpConstructor(sents, seedSets, labelUsingSeedSets, ansCl, gC, iC);
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, List<CoreLabel>> sents, Map<String, Set<String>> seedSets, boolean labelUsingSeedSets, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this(props, sents, seedSets, labelUsingSeedSets, answerClass, new HashMap<String, Class>(), new HashMap<String, Map<Class, Object>>());
    }

    public GetPatternsFromDataMultiClass(Properties props, Map<String, List<CoreLabel>> sents, Map<String, Set<String>> seedSets, boolean labelUsingSeedSets, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass, Map<String, Class> generalizeClasses, Map<String, Map<Class, Object>> ignoreClasses) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        this.props = props;
        if (ignoreClasses.isEmpty()) {
            for (String label : seedSets.keySet()) {
                ignoreClasses.put(label, new HashMap());
            }
        }
        this.setUpConstructor(sents, seedSets, labelUsingSeedSets, answerClass, generalizeClasses, ignoreClasses);
    }

    private void setUpConstructor(Map<String, List<CoreLabel>> sents, Map<String, Set<String>> seedSets, boolean labelUsingSeedSets, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass, Map<String, Class> generalizeClasses, Map<String, Map<Class, Object>> ignoreClasses) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, InterruptedException, ExecutionException, ClassNotFoundException {
        Data.sents = sents;
        Execution.fillOptions(Data.class, this.props);
        Execution.fillOptions((Object)this.constVars, this.props);
        this.constVars.answerClass = answerClass;
        this.constVars.ignoreWordswithClassesDuringSelection = ignoreClasses;
        this.constVars.addGeneralizeClasses(generalizeClasses);
        this.constVars.setLabelDictionary(seedSets);
        if (this.constVars.writeMatchedTokensFiles && this.constVars.batchProcessSents) {
            throw new RuntimeException("writeMatchedTokensFiles and batchProcessSents cannot be true at the same time (not implemented; also doesn't make sense to save a large sentences json file)");
        }
        this.constVars.setUp(this.props);
        if (this.constVars.debug < 1) {
            Redwood.hideChannelsEverywhere(ConstantsAndVariables.minimaldebug);
        }
        if (this.constVars.debug < 2) {
            Redwood.hideChannelsEverywhere(new Object[]{Redwood.DBG});
        }
        this.constVars.justify = true;
        if (this.constVars.debug < 3) {
            this.constVars.justify = false;
        }
        if (this.constVars.debug < 4) {
            Redwood.hideChannelsEverywhere(ConstantsAndVariables.extremedebug);
        }
        Redwood.log(new Object[]{Redwood.DBG, "Running with debug output"});
        Redwood.log(ConstantsAndVariables.extremedebug, "Running with extreme debug output");
        this.wordsPatExtracted = new HashMap<String, TwoDimensionalCounter<String, SurfacePattern>>();
        File invIndexDir = null;
        boolean createInvIndex = true;
        if (this.constVars.loadInvertedIndexDir != null) {
            createInvIndex = false;
            this.constVars.invertedIndex = InvertedIndexByTokens.loadIndex(this.constVars.loadInvertedIndexDir);
            if (this.constVars.invertedIndex.isBatchProcessed() != this.constVars.batchProcessSents) {
                throw new RuntimeException("The index was created with batchProcessSents as " + this.constVars.invertedIndex.isBatchProcessed() + ". Use the same flag or create a new index");
            }
            Redwood.log(new Object[]{Redwood.DBG, "Loaded index from " + this.constVars.loadInvertedIndexDir});
        } else if (this.constVars.saveInvertedIndexDir == null) {
            String dir = System.getProperty("java.io.tmpdir");
            invIndexDir = File.createTempFile(dir, ".dir");
            invIndexDir.delete();
            invIndexDir.deleteOnExit();
        }
        HashSet<String> specialwords4Index = new HashSet<String>();
        specialwords4Index.addAll(Arrays.asList("fw", "FW", "sw", "SW", "OTHERSEM", "othersem"));
        for (String label : answerClass.keySet()) {
            this.wordsPatExtracted.put(label, new TwoDimensionalCounter());
            specialwords4Index.add(label);
            specialwords4Index.add(label.toLowerCase());
        }
        this.scorePhrases = new ScorePhrases(this.props, this.constVars);
        this.createPats = new CreatePatterns(this.props, this.constVars);
        assert (!this.constVars.doNotApplyPatterns || !this.createPats.useStopWordsBeforeTerm && this.constVars.numWordsCompound <= 1) : " Cannot have both doNotApplyPatterns and (useStopWordsBeforeTerm true or numWordsCompound > 1)!";
        String prefixFileForIndex = null;
        if (this.constVars.usingDirForSentsInIndex) {
            prefixFileForIndex = this.constVars.saveSentencesSerDir;
        }
        if (createInvIndex) {
            this.constVars.invertedIndex = new InvertedIndexByTokens(invIndexDir, this.constVars.matchLowerCaseContext, this.constVars.getStopWords(), specialwords4Index, this.constVars.batchProcessSents, prefixFileForIndex);
        }
        int totalNumSents = 0;
        if (this.constVars.batchProcessSents) {
            if (createInvIndex || labelUsingSeedSets) {
                for (File f : Data.sentsFiles) {
                    Map sentsf = (Map)IOUtils.readObjectFromFile(f);
                    totalNumSents += sentsf.size();
                    if (createInvIndex) {
                        String filename = "";
                        filename = this.constVars.usingDirForSentsInIndex ? f.getName() : f.getAbsolutePath();
                        this.constVars.invertedIndex.add(sentsf, filename, this.constVars.useLemmaContextTokens);
                    }
                    Redwood.log(new Object[]{Redwood.DBG, "Initializing sents from " + f + " with " + sentsf.size() + " sentences, either by labeling with the seed set or just setting the right classes"});
                    for (String l : this.constVars.answerClass.keySet()) {
                        HashSet<String> otherseed;
                        HashSet<String> seed = seedSets == null || !labelUsingSeedSets ? new HashSet<String>() : (seedSets.containsKey(l) ? seedSets.get(l) : new HashSet<String>());
                        GetPatternsFromDataMultiClass.runLabelSeedWords(sentsf, this.constVars.answerClass.get(l), l, seed, this.constVars);
                        Set<Object> set = otherseed = this.constVars.getOtherSemanticClasses() == null || !labelUsingSeedSets ? new HashSet() : this.constVars.getOtherSemanticClasses();
                        if (this.constVars.addIndvWordsFromPhrasesExceptLastAsNeg) {
                            for (String s : seed) {
                                String[] t = s.split("\\s+");
                                for (int i = 0; i < t.length - 1; ++i) {
                                    if (seed.contains(t[i])) continue;
                                    otherseed.add(t[i]);
                                }
                            }
                        }
                        if (this.constVars.getOtherSemanticClasses() == null) continue;
                        GetPatternsFromDataMultiClass.runLabelSeedWords(sentsf, PatternsAnnotations.OtherSemanticLabel.class, "OTHERSEM", otherseed, this.constVars);
                    }
                    Redwood.log(new Object[]{Redwood.DBG, "Saving the labeled seed sents (if given the option) to the same file " + f});
                    IOUtils.writeObjectToFile((Object)sentsf, f);
                }
            }
        } else {
            totalNumSents = Data.sents.size();
            if (createInvIndex) {
                this.constVars.invertedIndex.add(Data.sents, "1", this.constVars.useLemmaContextTokens);
            }
            Redwood.log(new Object[]{Redwood.DBG, "Initializing sents " + Data.sents.size() + " sentences, either by labeling with the seed set or just setting the right classes"});
            for (String l : this.constVars.answerClass.keySet()) {
                HashSet<String> otherseed;
                HashSet<String> seed = seedSets == null || !labelUsingSeedSets ? new HashSet<String>() : (seedSets.containsKey(l) ? seedSets.get(l) : new HashSet<String>());
                GetPatternsFromDataMultiClass.runLabelSeedWords(Data.sents, this.constVars.answerClass.get(l), l, seed, this.constVars);
                Set<Object> set = otherseed = this.constVars.getOtherSemanticClasses() == null || !labelUsingSeedSets ? new HashSet() : this.constVars.getOtherSemanticClasses();
                if (this.constVars.getOtherSemanticClasses() == null) continue;
                GetPatternsFromDataMultiClass.runLabelSeedWords(Data.sents, PatternsAnnotations.OtherSemanticLabel.class, "OTHERSEM", otherseed, this.constVars);
            }
        }
        if (this.constVars.saveInvertedIndexDir != null) {
            IOUtils.ensureDir(new File(this.constVars.saveInvertedIndexDir));
            this.constVars.invertedIndex.saveIndex(this.constVars.saveInvertedIndexDir);
        }
        Redwood.log(new Object[]{Redwood.DBG, "Done creating inverted index of " + this.constVars.invertedIndex.size() + " tokens and labeling data with total of " + totalNumSents + " sentences"});
        if (this.constVars.usePatternEvalWordClass || this.constVars.usePhraseEvalWordClass) {
            if (this.constVars.externalFeatureWeightsFile == null) {
                File f = File.createTempFile("tempfeat", ".txt");
                f.delete();
                f.deleteOnExit();
                this.constVars.externalFeatureWeightsFile = f.getAbsolutePath();
            }
            for (String label : seedSets.keySet()) {
                String externalFeatureWeightsFileLabel = this.constVars.externalFeatureWeightsFile + "_" + label;
                File f = new File(externalFeatureWeightsFileLabel);
                if (!f.exists()) {
                    Redwood.log(new Object[]{Redwood.DBG, "externalweightsfile for the label " + label + " does not exist: learning weights!"});
                    LearnImportantFeatures lmf = new LearnImportantFeatures();
                    Execution.fillOptions((Object)lmf, this.props);
                    lmf.answerClass = answerClass.get(label);
                    lmf.answerLabel = label;
                    lmf.setUp();
                    lmf.getTopFeatures(this.constVars.batchProcessSents, Data.sentsFiles, Data.sents, this.constVars.perSelectRand, this.constVars.perSelectNeg, externalFeatureWeightsFileLabel);
                }
                ClassicCounter<Integer> distSimWeightsLabel = new ClassicCounter<Integer>();
                for (String line : IOUtils.readLines(externalFeatureWeightsFileLabel)) {
                    String s;
                    String[] t = line.split(":");
                    if (!t[0].startsWith("Cluster")) continue;
                    s = t[0].replace("Cluster-", "");
                    Integer clusterNum = Integer.parseInt(s);
                    distSimWeightsLabel.setCount(clusterNum, Double.parseDouble(t[1]));
                }
                this.constVars.distSimWeights.put(label, distSimWeightsLabel);
            }
        }
        if (this.constVars.usePatternEvalSemanticOdds || this.constVars.usePhraseEvalSemanticOdds) {
            Counter dictOddsWeightsLabel = new ClassicCounter();
            Counter<String> otherSemanticClassFreq = new ClassicCounter();
            for (String s : this.constVars.getOtherSemanticClasses()) {
                for (String s1 : StringUtils.getNgrams(Arrays.asList(s.split("\\s+")), 1, this.constVars.numWordsCompound)) {
                    otherSemanticClassFreq.incrementCount(s1);
                }
            }
            otherSemanticClassFreq = Counters.add(otherSemanticClassFreq, 1.0);
            HashMap labelDictNgram = new HashMap();
            for (String label : seedSets.keySet()) {
                Counter<String> classFreq = new ClassicCounter();
                for (String s : seedSets.get(label)) {
                    for (String s1 : StringUtils.getNgrams(Arrays.asList(s.split("\\s+")), 1, this.constVars.numWordsCompound)) {
                        classFreq.incrementCount(s1);
                    }
                }
                classFreq = Counters.add(classFreq, 1.0);
                labelDictNgram.put(label, classFreq);
            }
            for (String label : seedSets.keySet()) {
                ClassicCounter<String> otherLabelFreq = new ClassicCounter<String>();
                for (String label2 : seedSets.keySet()) {
                    if (label.equals(label2)) continue;
                    otherLabelFreq.addAll((Counter)labelDictNgram.get(label2));
                }
                otherLabelFreq.addAll(otherSemanticClassFreq);
                dictOddsWeightsLabel = Counters.divisionNonNaN((Counter)labelDictNgram.get(label), otherLabelFreq);
                this.constVars.dictOddsWeights.put(label, dictOddsWeightsLabel);
            }
        }
    }

    public static Map<String, List<CoreLabel>> runPOSNEROnTokens(List<CoreMap> sentsCM, String posModelPath, boolean useTargetNERRestriction, String prefix, boolean useTargetParserParentRestriction, String numThreads) {
        Annotation doc = new Annotation(sentsCM);
        Properties props = new Properties();
        ArrayList<String> anns = new ArrayList<String>();
        anns.add("pos");
        anns.add("lemma");
        if (useTargetParserParentRestriction) {
            anns.add("parse");
        }
        if (useTargetNERRestriction) {
            anns.add("ner");
        }
        props.setProperty("annotators", StringUtils.join(anns, ","));
        props.setProperty("parse.maxlen", "80");
        props.setProperty("nthreads", numThreads);
        props.setProperty("threads", numThreads);
        if (posModelPath != null) {
            props.setProperty("pos.model", posModelPath);
        }
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props, false);
        Redwood.log(new Object[]{Redwood.DBG, "Annotating text"});
        pipeline.annotate(doc);
        Redwood.log(new Object[]{Redwood.DBG, "Done annotating text"});
        HashMap<String, List<CoreLabel>> sents = new HashMap<String, List<CoreLabel>>();
        for (CoreMap s : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
            if (useTargetParserParentRestriction) {
                GetPatternsFromDataMultiClass.inferParentParseTag((Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class));
            }
            sents.put(prefix + (String)s.get(CoreAnnotations.DocIDAnnotation.class), (List<CoreLabel>)s.get(CoreAnnotations.TokensAnnotation.class));
        }
        return sents;
    }

    public static int tokenize(String text, String posModelPath, boolean lowercase, boolean useTargetNERRestriction, String sentIDPrefix, boolean useTargetParserParentRestriction, String numThreads, boolean batchProcessSents, int numMaxSentencesPerBatchFile, File saveSentencesSerDirFile, Map<String, List<CoreLabel>> sents, int numFilesTillNow) throws InterruptedException, ExecutionException, IOException {
        if (pipeline == null) {
            Properties props = new Properties();
            ArrayList<String> anns = new ArrayList<String>();
            anns.add("tokenize");
            anns.add("ssplit");
            anns.add("pos");
            anns.add("lemma");
            if (useTargetParserParentRestriction) {
                anns.add("parse");
            }
            if (useTargetNERRestriction) {
                anns.add("ner");
            }
            props.setProperty("annotators", StringUtils.join(anns, ","));
            props.setProperty("parse.maxlen", "80");
            props.setProperty("threads", numThreads);
            props.put("tokenize.options", "ptb3Escaping=false,normalizeParentheses=false,escapeForwardSlashAsterisk=false");
            if (posModelPath != null) {
                props.setProperty("pos.model", posModelPath);
            }
            pipeline = new StanfordCoreNLP(props);
        }
        if (lowercase) {
            text = text.toLowerCase();
        }
        Annotation doc = new Annotation(text);
        pipeline.annotate(doc);
        Redwood.log(new Object[]{Redwood.DBG, "Done annotating text"});
        int i = -1;
        for (CoreMap s : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
            ++i;
            if (useTargetParserParentRestriction) {
                GetPatternsFromDataMultiClass.inferParentParseTag((Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class));
            }
            sents.put(sentIDPrefix + i, (List<CoreLabel>)s.get(CoreAnnotations.TokensAnnotation.class));
            if (!batchProcessSents || sents.size() < numMaxSentencesPerBatchFile) continue;
            File file = new File(saveSentencesSerDirFile + "/sents_" + ++numFilesTillNow);
            IOUtils.writeObjectToFile(sents, file);
            sents = new HashMap<String, List<CoreLabel>>();
            Data.sentsFiles.add(file);
        }
        if (sents.size() > 0 && batchProcessSents) {
            File file = new File(saveSentencesSerDirFile + "/sents_" + ++numFilesTillNow);
            IOUtils.writeObjectToFile(sents, file);
            Data.sentsFiles.add(file);
            sents.clear();
        }
        if (batchProcessSents) {
            sents = null;
        }
        return numFilesTillNow;
    }

    static void inferParentParseTag(Tree tree) {
        String grandstr = tree.value();
        for (Tree child : tree.children()) {
            for (Tree grand : child.children()) {
                if (!grand.isLeaf()) continue;
                ((CoreLabel)grand.label()).set(CoreAnnotations.GrandparentAnnotation.class, grandstr);
            }
            GetPatternsFromDataMultiClass.inferParentParseTag(child);
        }
    }

    public static List<Integer> getSubListIndex(String[] l1, String[] l2, String[] subl2, Set<String> englishWords, HashSet<String> seenFuzzyMatches, int minLen4Fuzzy) {
        if (l1.length > l2.length) {
            return null;
        }
        EditDistance editDistance = new EditDistance(true);
        ArrayList<Integer> allIndices = new ArrayList<Integer>();
        boolean matched = false;
        int index = -1;
        int lastUnmatchedIndex = 0;
        int i = 0;
        while (i < l2.length) {
            int j = 0;
            while (j < l1.length) {
                boolean d1 = false;
                boolean d2 = false;
                boolean compareFuzzy = true;
                if (englishWords.contains(l2[i]) || englishWords.contains(subl2[i]) || l2[i].length() <= minLen4Fuzzy || subl2[i].length() <= minLen4Fuzzy) {
                    compareFuzzy = false;
                }
                if (!compareFuzzy || l1[j].length() <= minLen4Fuzzy) {
                    boolean bl = d1 = l1[j].equals(l2[i]);
                    if (!d1) {
                        d2 = subl2[i].equals(l1[j]);
                    }
                } else {
                    String combo = l1[j] + "#" + l2[i];
                    if (l1[j].equals(l2[i]) || seenFuzzyMatches.contains(combo)) {
                        d1 = true;
                    } else {
                        boolean bl = d1 = editDistance.score(l1[j], l2[i]) <= 1.0;
                        if (!d1) {
                            String combo2 = l1[j] + "#" + subl2[i];
                            if (l1[j].equals(subl2[i]) || seenFuzzyMatches.contains(combo2)) {
                                d2 = true;
                            } else {
                                boolean bl2 = d2 = editDistance.score(l1[j], subl2[i]) <= 1.0;
                                if (d2) {
                                    seenFuzzyMatches.add(combo2);
                                }
                            }
                        } else if (d1) {
                            seenFuzzyMatches.add(combo);
                        }
                    }
                }
                if (d1 || d2) {
                    index = i++;
                    if (++j == l1.length) {
                        matched = true;
                        break;
                    }
                } else {
                    j = 0;
                    lastUnmatchedIndex = i = lastUnmatchedIndex + 1;
                    index = -1;
                    if (lastUnmatchedIndex == l2.length) break;
                }
                if (i < l2.length) continue;
                index = -1;
                break;
            }
            if (i != l2.length && !matched) continue;
            if (index >= 0) {
                allIndices.add(index - l1.length + 1);
            }
            matched = false;
            lastUnmatchedIndex = index;
        }
        return allIndices;
    }

    public static void runLabelSeedWords(Map<String, List<CoreLabel>> sents, Class answerclass, String label, Set<String> seedWords, ConstantsAndVariables constVars) throws InterruptedException, ExecutionException, IOException {
        ArrayList<String> keyset = new ArrayList<String>(sents.keySet());
        int num = 0;
        num = constVars.numThreads == 1 ? keyset.size() : keyset.size() / (constVars.numThreads - 1);
        ExecutorService executor = Executors.newFixedThreadPool(constVars.numThreads);
        Redwood.log(ConstantsAndVariables.extremedebug, "keyset size is " + keyset.size());
        ArrayList<Future<Map<String, List<CoreLabel>>>> list = new ArrayList<Future<Map<String, List<CoreLabel>>>>();
        for (int i = 0; i < constVars.numThreads; ++i) {
            List<String> list2 = keyset.subList(i * num, Math.min(keyset.size(), (i + 1) * num));
            Redwood.log(ConstantsAndVariables.extremedebug, "assigning from " + i * num + " till " + Math.min(keyset.size(), (i + 1) * num));
            LabelWithSeedWords task = new LabelWithSeedWords(seedWords, sents, list2, answerclass, label, constVars.minLen4FuzzyForPattern, constVars.backgroundSymbol, constVars.getEnglishWords());
            Future<Map<String, List<CoreLabel>>> submit = executor.submit(task);
            list.add(submit);
        }
        for (Future future : list) {
            try {
                sents.putAll((Map)future.get());
            }
            catch (Exception e) {
                executor.shutdownNow();
                throw new RuntimeException(e);
            }
        }
        executor.shutdown();
    }

    public Counter<SurfacePattern> getPatterns(String label, Set<SurfacePattern> alreadyIdentifiedPatterns, SurfacePattern p0, Counter<String> p0Set, Set<SurfacePattern> ignorePatterns) throws InterruptedException, ExecutionException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ScorePatterns scorePatterns;
        TwoDimensionalCounter<SurfacePattern, String> patternsandWords4Label = new TwoDimensionalCounter<SurfacePattern, String>();
        TwoDimensionalCounter<SurfacePattern, String> negPatternsandWords4Label = new TwoDimensionalCounter<SurfacePattern, String>();
        TwoDimensionalCounter<SurfacePattern, String> posnegPatternsandWords4Label = new TwoDimensionalCounter<SurfacePattern, String>();
        TwoDimensionalCounter<SurfacePattern, String> unLabeledPatternsandWords4Label = new TwoDimensionalCounter<SurfacePattern, String>();
        TwoDimensionalCounter<SurfacePattern, String> negandUnLabeledPatternsandWords4Label = new TwoDimensionalCounter<SurfacePattern, String>();
        TwoDimensionalCounter<SurfacePattern, String> allPatternsandWords4Label = new TwoDimensionalCounter<SurfacePattern, String>();
        if (!this.constVars.batchProcessSents) {
            if (this.patternsForEachToken == null) {
                if (this.constVars.computeAllPatterns) {
                    Redwood.log(new Object[]{Redwood.DBG, "Computing all patterns"});
                    this.patternsForEachToken = this.createPats.getAllPatterns(label, Data.sents);
                    this.constVars.computeAllPatterns = false;
                } else {
                    this.patternsForEachToken = (Map)IOUtils.readObjectFromFile(this.constVars.allPatternsFile);
                    Redwood.log(ConstantsAndVariables.minimaldebug, "Read all patterns from " + this.constVars.allPatternsFile);
                }
            }
            this.calculateSufficientStats(Data.sents, this.patternsForEachToken, label, patternsandWords4Label, posnegPatternsandWords4Label, allPatternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, negandUnLabeledPatternsandWords4Label);
        } else {
            for (File f : Data.sentsFiles) {
                Redwood.log(new Object[]{Redwood.DBG, (this.constVars.computeAllPatterns ? "Creating patterns and " : "") + "calculating sufficient statistics from " + f});
                Map sents = (Map)IOUtils.readObjectFromFile(f);
                Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>> pats4File = null;
                if (this.constVars.computeAllPatterns) {
                    if (this.patternsForEachToken == null) {
                        this.patternsForEachToken = new HashMap<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>>();
                    }
                    pats4File = this.createPats.getAllPatterns(label, sents);
                    this.patternsForEachToken.putAll(pats4File);
                } else {
                    if (this.patternsForEachToken == null) {
                        this.patternsForEachToken = (Map)IOUtils.readObjectFromFile(this.constVars.allPatternsFile);
                        Redwood.log(ConstantsAndVariables.minimaldebug, "Read all patterns from " + this.constVars.allPatternsFile);
                    }
                    pats4File = this.patternsForEachToken;
                }
                this.calculateSufficientStats(sents, pats4File, label, patternsandWords4Label, posnegPatternsandWords4Label, allPatternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, negandUnLabeledPatternsandWords4Label);
            }
        }
        if (this.constVars.computeAllPatterns && this.constVars.allPatternsFile != null) {
            IOUtils.writeObjectToFile(this.patternsForEachToken, this.constVars.allPatternsFile);
        }
        if (this.patternsandWords == null) {
            this.patternsandWords = new HashMap<String, TwoDimensionalCounter<SurfacePattern, String>>();
        }
        if (this.allPatternsandWords == null) {
            this.allPatternsandWords = new HashMap<String, TwoDimensionalCounter<SurfacePattern, String>>();
        }
        if (this.currentPatternWeights == null) {
            this.currentPatternWeights = new HashMap<String, Counter<SurfacePattern>>();
        }
        Counter<Object> currentPatternWeights4Label = new ClassicCounter();
        Set<SurfacePattern> removePats = this.enforceMinSupportRequirements(patternsandWords4Label, unLabeledPatternsandWords4Label);
        Counters.removeKeys(patternsandWords4Label, removePats);
        Counters.removeKeys(unLabeledPatternsandWords4Label, removePats);
        Counters.removeKeys(negandUnLabeledPatternsandWords4Label, removePats);
        Counters.removeKeys(allPatternsandWords4Label, removePats);
        Counters.removeKeys(posnegPatternsandWords4Label, removePats);
        Counters.removeKeys(negPatternsandWords4Label, removePats);
        Class patternscoringclass = GetPatternsFromDataMultiClass.getPatternScoringClass(this.constVars.patternScoring);
        if (patternscoringclass != null && patternscoringclass.equals(ScorePatternsF1.class)) {
            scorePatterns = new ScorePatternsF1(this.constVars, this.constVars.patternScoring, label, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, negandUnLabeledPatternsandWords4Label, allPatternsandWords4Label, this.props, p0Set, p0);
            Counter<SurfacePattern> finalPat = scorePatterns.score();
            Counters.removeKeys(finalPat, alreadyIdentifiedPatterns);
            Counters.retainNonZeros(finalPat);
            Counters.retainTop(finalPat, 1);
            if (Double.isNaN(Counters.max(finalPat))) {
                throw new RuntimeException("how is the value NaN");
            }
            Redwood.log(ConstantsAndVariables.minimaldebug, "Selected Pattern: " + finalPat);
            return finalPat;
        }
        if (patternscoringclass != null && patternscoringclass.equals(ScorePatternsRatioModifiedFreq.class)) {
            scorePatterns = new ScorePatternsRatioModifiedFreq(this.constVars, this.constVars.patternScoring, label, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, negandUnLabeledPatternsandWords4Label, allPatternsandWords4Label, this.phInPatScoresCache, this.scorePhrases, this.props);
        } else if (patternscoringclass != null && patternscoringclass.equals(ScorePatternsFreqBased.class)) {
            scorePatterns = new ScorePatternsFreqBased(this.constVars, this.constVars.patternScoring, label, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, negandUnLabeledPatternsandWords4Label, allPatternsandWords4Label, this.props);
        } else if (this.constVars.patternScoring.equals((Object)PatternScoring.kNN)) {
            try {
                Class<?> clazz = Class.forName("edu.stanford.nlp.patterns.surface.ScorePatternsKNN");
                Constructor<?> ctor = clazz.getConstructor(ConstantsAndVariables.class, PatternScoring.class, String.class, TwoDimensionalCounter.class, TwoDimensionalCounter.class, TwoDimensionalCounter.class, TwoDimensionalCounter.class, TwoDimensionalCounter.class, ScorePhrases.class, Properties.class);
                scorePatterns = (ScorePatterns)ctor.newInstance(new Object[]{this.constVars, this.constVars.patternScoring, label, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, negandUnLabeledPatternsandWords4Label, allPatternsandWords4Label, this.scorePhrases, this.props});
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("kNN pattern scoring is not released yet. Stay tuned.");
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("newinstance of kNN not created", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("newinstance of kNN not created", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("newinstance of kNN not created", e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("newinstance of kNN not created", e);
            }
        } else {
            throw new RuntimeException((Object)((Object)this.constVars.patternScoring) + " is not implemented (check spelling?). ");
        }
        scorePatterns.setUp(this.props);
        currentPatternWeights4Label = scorePatterns.score();
        Redwood.log(ConstantsAndVariables.extremedebug, "patterns counter size is " + currentPatternWeights4Label.size());
        if (ignorePatterns != null && !ignorePatterns.isEmpty()) {
            Counters.removeKeys(currentPatternWeights4Label, ignorePatterns);
            Redwood.log(ConstantsAndVariables.extremedebug, "Removing patterns from ignorePatterns of size  " + ignorePatterns.size() + ". New patterns size " + currentPatternWeights4Label.size());
        }
        if (alreadyIdentifiedPatterns != null && !alreadyIdentifiedPatterns.isEmpty()) {
            Counters.removeKeys(currentPatternWeights4Label, alreadyIdentifiedPatterns);
            Redwood.log(ConstantsAndVariables.extremedebug, "Removing already identified patterns of size  " + alreadyIdentifiedPatterns.size() + ". New patterns size " + currentPatternWeights4Label.size());
        }
        PriorityQueue<Object> q = Counters.toPriorityQueue(currentPatternWeights4Label);
        int num = 0;
        ClassicCounter<SurfacePattern> chosenPat = new ClassicCounter<SurfacePattern>();
        HashSet<SurfacePattern> removePatterns = new HashSet<SurfacePattern>();
        HashSet<SurfacePattern> removeIdentifiedPatterns = null;
        while (num < this.constVars.numPatterns && !q.isEmpty()) {
            SurfacePattern pat = (SurfacePattern)q.removeFirst();
            if (currentPatternWeights4Label.getCount(pat) < this.constVars.thresholdSelectPattern) {
                Redwood.log(new Object[]{Redwood.DBG, "The max weight of candidate patterns is " + this.df.format(currentPatternWeights4Label.getCount(pat)) + " so not adding anymore patterns"});
                break;
            }
            boolean notchoose = false;
            if (!unLabeledPatternsandWords4Label.containsFirstKey(pat) || ((ClassicCounter)unLabeledPatternsandWords4Label.getCounter((Object)pat)).isEmpty()) {
                Redwood.log(ConstantsAndVariables.extremedebug, "Removing pattern " + pat + " because it has no unlab support; pos words: " + patternsandWords4Label.getCounter((Object)pat) + " and all words " + allPatternsandWords4Label.getCounter((Object)pat));
                notchoose = true;
                continue;
            }
            HashSet<SurfacePattern> removeChosenPats = null;
            if (!notchoose && alreadyIdentifiedPatterns != null) {
                for (SurfacePattern surfacePattern : alreadyIdentifiedPatterns) {
                    if (SurfacePattern.subsumes(pat, surfacePattern)) {
                        Redwood.log(ConstantsAndVariables.extremedebug, "Not choosing pattern " + pat + " because it is contained in or contains the already chosen pattern " + surfacePattern);
                        notchoose = true;
                        break;
                    }
                    int rest = pat.equalContext(surfacePattern);
                    if (rest == Integer.MAX_VALUE) continue;
                    if (rest < 0) {
                        if (removeIdentifiedPatterns == null) {
                            removeIdentifiedPatterns = new HashSet<SurfacePattern>();
                        }
                        removeIdentifiedPatterns.add(surfacePattern);
                        continue;
                    }
                    notchoose = true;
                    break;
                }
            }
            if (!notchoose) {
                for (SurfacePattern surfacePattern : chosenPat.keySet()) {
                    boolean removeChosenPatFlag = false;
                    if (!SurfacePattern.sameGenre(pat, surfacePattern)) continue;
                    if (SurfacePattern.subsumes(pat, surfacePattern)) {
                        Redwood.log(ConstantsAndVariables.extremedebug, "Not choosing pattern " + pat + " because it is contained in or contains the already chosen pattern " + surfacePattern);
                        notchoose = true;
                        break;
                    }
                    if (SurfacePattern.subsumes(surfacePattern, pat)) {
                        int rest = pat.equalContext(surfacePattern);
                        if (rest == Integer.MAX_VALUE) {
                            Redwood.log(ConstantsAndVariables.extremedebug, "Not choosing pattern " + surfacePattern + " because it is contained in or contains another chosen pattern in this iteration " + pat);
                            removeChosenPatFlag = true;
                        } else if (rest < 0) {
                            removeChosenPatFlag = true;
                        } else {
                            notchoose = true;
                            break;
                        }
                    }
                    if (!removeChosenPatFlag) continue;
                    if (removeChosenPats == null) {
                        removeChosenPats = new HashSet<SurfacePattern>();
                    }
                    removeChosenPats.add(surfacePattern);
                    --num;
                }
            }
            if (notchoose) {
                Redwood.log(new Object[]{Redwood.DBG, "Not choosing " + pat + " for whatever reason!"});
                continue;
            }
            if (removeChosenPats != null) {
                Redwood.log(ConstantsAndVariables.extremedebug, "Removing already chosen patterns in this iteration " + removeChosenPats + " in favor of " + pat);
                Counters.removeKeys(chosenPat, removeChosenPats);
            }
            if (removeIdentifiedPatterns != null) {
                Redwood.log(ConstantsAndVariables.extremedebug, "Removing already identified patterns " + removeIdentifiedPatterns + " in favor of " + pat);
                removePatterns.addAll(removeIdentifiedPatterns);
            }
            chosenPat.setCount(pat, currentPatternWeights4Label.getCount(pat));
            ++num;
        }
        this.removeLearnedPatterns(label, removePatterns);
        Redwood.log(new Object[]{Redwood.DBG, "final size of the patterns is " + chosenPat.size()});
        Redwood.log(ConstantsAndVariables.minimaldebug, "## Selected Patterns ## \n");
        List chosenPatSorted = Counters.toSortedListWithCounts(chosenPat);
        for (Pair en : chosenPatSorted) {
            Redwood.log(ConstantsAndVariables.minimaldebug, ((SurfacePattern)en.first()).toStringToWrite() + ":" + this.df.format(en.second) + "\n");
        }
        if (this.constVars.outDir != null && !this.constVars.outDir.isEmpty()) {
            CollectionValuedMap<SurfacePattern, String> posWords = new CollectionValuedMap<SurfacePattern, String>();
            for (Map.Entry<SurfacePattern, ClassicCounter<String>> en : patternsandWords4Label.entrySet()) {
                posWords.addAll(en.getKey(), en.getValue().keySet());
            }
            CollectionValuedMap negWords = new CollectionValuedMap();
            for (Map.Entry entry : negPatternsandWords4Label.entrySet()) {
                negWords.addAll(entry.getKey(), ((ClassicCounter)entry.getValue()).keySet());
            }
            CollectionValuedMap<SurfacePattern, String> unlabWords = new CollectionValuedMap<SurfacePattern, String>();
            for (Map.Entry<SurfacePattern, ClassicCounter<String>> en : unLabeledPatternsandWords4Label.entrySet()) {
                unlabWords.addAll(en.getKey(), en.getValue().keySet());
            }
            String string = this.constVars.outDir + "/" + this.constVars.identifier + "/" + label;
            Redwood.log(ConstantsAndVariables.minimaldebug, "Saving output in " + string);
            IOUtils.ensureDir(new File(string));
            String filename = string + "/patterns" + ".json";
            JsonArrayBuilder obj = Json.createArrayBuilder();
            if (this.writtenPatInJustification.containsKey(label) && this.writtenPatInJustification.get(label).booleanValue()) {
                JsonReader jsonReader = Json.createReader((InputStream)new BufferedInputStream(new FileInputStream(filename)));
                JsonArray objarr = jsonReader.readArray();
                jsonReader.close();
                for (JsonObjectBuilder o : objarr) {
                    obj.add((JsonValue)o);
                }
            } else {
                obj = Json.createArrayBuilder();
            }
            JsonObjectBuilder objThisIter = Json.createObjectBuilder();
            for (Pair pat : chosenPatSorted) {
                String w;
                JsonObjectBuilder o;
                o = Json.createObjectBuilder();
                JsonArrayBuilder pos = Json.createArrayBuilder();
                JsonArrayBuilder neg = Json.createArrayBuilder();
                JsonArrayBuilder unlab = Json.createArrayBuilder();
                Iterator i$ = posWords.get(pat.first()).iterator();
                while (i$.hasNext()) {
                    w = (String)i$.next();
                    pos.add(w);
                }
                i$ = negWords.get(pat.first()).iterator();
                while (i$.hasNext()) {
                    w = (String)i$.next();
                    neg.add(w);
                }
                i$ = unlabWords.get(pat.first()).iterator();
                while (i$.hasNext()) {
                    w = (String)i$.next();
                    unlab.add(w);
                }
                o.add("Positive", pos);
                o.add("Negative", neg);
                o.add("Unlabeled", unlab);
                o.add("Score", pat.second().doubleValue());
                objThisIter.add(((SurfacePattern)pat.first()).toStringSimple(), o);
            }
            obj.add((JsonValue)objThisIter.build());
            IOUtils.ensureDir(new File(filename).getParentFile());
            IOUtils.writeStringToFile(obj.build().toString(), filename, "utf8");
            this.writtenPatInJustification.put(label, true);
        }
        if (this.constVars.justify) {
            Redwood.log(new Object[]{Redwood.DBG, "Justification for Patterns:"});
            for (SurfacePattern key : chosenPat.keySet()) {
                Redwood.log(new Object[]{Redwood.DBG, "\nPattern: " + key.toStringToWrite()});
                Redwood.log(new Object[]{Redwood.DBG, "Positive Words:" + Counters.toSortedString(patternsandWords4Label.getCounter((Object)key), ((ClassicCounter)patternsandWords4Label.getCounter((Object)key)).size(), "%1$s:%2$f", ";")});
                Redwood.log(new Object[]{Redwood.DBG, "Negative Words:" + Counters.toSortedString(negPatternsandWords4Label.getCounter((Object)key), ((ClassicCounter)negPatternsandWords4Label.getCounter((Object)key)).size(), "%1$s:%2$f", ";")});
                Redwood.log(new Object[]{Redwood.DBG, "Unlabeled Words:" + Counters.toSortedString(unLabeledPatternsandWords4Label.getCounter((Object)key), ((ClassicCounter)unLabeledPatternsandWords4Label.getCounter((Object)key)).size(), "%1$s:%2$f", ";")});
            }
        }
        this.allPatternsandWords.put(label, allPatternsandWords4Label);
        this.patternsandWords.put(label, patternsandWords4Label);
        this.currentPatternWeights.put(label, currentPatternWeights4Label);
        return chosenPat;
    }

    public static Class getPatternScoringClass(PatternScoring patternScoring) {
        if (patternScoring.equals((Object)PatternScoring.F1SeedPattern)) {
            return ScorePatternsF1.class;
        }
        if (patternScoring.equals((Object)PatternScoring.PosNegUnlabOdds) || patternScoring.equals((Object)PatternScoring.PosNegOdds) || patternScoring.equals((Object)PatternScoring.RatioAll) || patternScoring.equals((Object)PatternScoring.PhEvalInPat) || patternScoring.equals((Object)PatternScoring.PhEvalInPatLogP) || patternScoring.equals((Object)PatternScoring.LOGREG) || patternScoring.equals((Object)PatternScoring.LOGREGlogP) || patternScoring.equals((Object)PatternScoring.SqrtAllRatio)) {
            return ScorePatternsRatioModifiedFreq.class;
        }
        if (patternScoring.equals((Object)PatternScoring.RlogF) || patternScoring.equals((Object)PatternScoring.RlogFPosNeg) || patternScoring.equals((Object)PatternScoring.RlogFUnlabNeg) || patternScoring.equals((Object)PatternScoring.RlogFNeg) || patternScoring.equals((Object)PatternScoring.YanGarber02) || patternScoring.equals((Object)PatternScoring.LinICML03)) {
            return ScorePatternsFreqBased.class;
        }
        return null;
    }

    private void calculateSufficientStats(Map<String, List<CoreLabel>> sents, Map<String, Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>>> patternsForEachToken, String label, TwoDimensionalCounter<SurfacePattern, String> patternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> posnegPatternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> allPatternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> negPatternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> unLabeledPatternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> negandUnLabeledPatternsandWords4Label) {
        Class<? extends TypesafeMap.Key<String>> answerClass4Label = this.constVars.answerClass.get(label);
        for (Map.Entry<String, List<CoreLabel>> sentEn : sents.entrySet()) {
            Map<Integer, Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>>> pat4Sent = patternsForEachToken.get(sentEn.getKey());
            if (pat4Sent == null) {
                throw new RuntimeException("How come there are no patterns for " + sentEn.getKey() + ". The total patternsForEachToken size is " + patternsForEachToken.size() + " and keys " + patternsForEachToken.keySet());
            }
            List<CoreLabel> sent = sentEn.getValue();
            for (int i = 0; i < sent.size(); ++i) {
                CoreLabel token = sent.get(i);
                Set matchedPhrases = (Set)token.get(PatternsAnnotations.MatchedPhrases.class);
                String tokenWordOrLemma = token.word();
                String longestMatchingPhrase = null;
                if (this.constVars.useMatchingPhrase) {
                    if (matchedPhrases != null && !matchedPhrases.isEmpty()) {
                        for (String s : matchedPhrases) {
                            if (s.equals(tokenWordOrLemma)) {
                                longestMatchingPhrase = tokenWordOrLemma;
                                break;
                            }
                            if (longestMatchingPhrase != null && longestMatchingPhrase.length() <= s.length()) continue;
                            longestMatchingPhrase = s;
                        }
                    } else {
                        longestMatchingPhrase = tokenWordOrLemma;
                    }
                } else {
                    longestMatchingPhrase = tokenWordOrLemma;
                }
                Triple<Set<SurfacePattern>, Set<SurfacePattern>, Set<SurfacePattern>> pat = pat4Sent.get(i);
                if (pat == null) {
                    throw new RuntimeException("Why are patterns null for sentence " + sentEn.getKey() + " and token " + i);
                }
                Set<SurfacePattern> prevPat = pat.first();
                Set<SurfacePattern> nextPat = pat.second();
                Set<SurfacePattern> prevnextPat = pat.third();
                if (this.constVars.ignoreWordRegex.matcher(token.word()).matches()) continue;
                String tag = token.tag();
                if (this.constVars.allowedTagsInitials != null && this.constVars.allowedTagsInitials.containsKey(label)) {
                    boolean use = false;
                    for (String allowed : this.constVars.allowedTagsInitials.get(label)) {
                        if (!tag.startsWith(allowed)) continue;
                        use = true;
                        break;
                    }
                    if (!use) continue;
                }
                String nertag = token.ner();
                if (this.constVars.allowedNERsforLabels != null && this.constVars.allowedNERsforLabels.containsKey(label) && !this.constVars.allowedNERsforLabels.get(label).contains(nertag)) continue;
                if (token.get(answerClass4Label).equals(label)) {
                    boolean nextTokenLabel;
                    boolean prevTokenLabel = i == 0 ? false : sent.get(i - 1).get(answerClass4Label).equals(label);
                    boolean bl = nextTokenLabel = i == sent.size() - 1 ? false : sent.get(i + 1).get(answerClass4Label).equals(label);
                    if (!this.constVars.ignorePatWithLabeledNeigh || !prevTokenLabel) {
                        for (SurfacePattern s : prevPat) {
                            ((ClassicCounter)patternsandWords4Label.getCounter((Object)s)).incrementCount(longestMatchingPhrase);
                            ((ClassicCounter)posnegPatternsandWords4Label.getCounter((Object)s)).incrementCount(longestMatchingPhrase);
                            ((ClassicCounter)allPatternsandWords4Label.getCounter((Object)s)).incrementCount(longestMatchingPhrase);
                        }
                    }
                    if (!this.constVars.ignorePatWithLabeledNeigh || !nextTokenLabel) {
                        for (SurfacePattern s : nextPat) {
                            ((ClassicCounter)patternsandWords4Label.getCounter((Object)s)).incrementCount(longestMatchingPhrase);
                            ((ClassicCounter)posnegPatternsandWords4Label.getCounter((Object)s)).incrementCount(longestMatchingPhrase);
                            ((ClassicCounter)allPatternsandWords4Label.getCounter((Object)s)).incrementCount(longestMatchingPhrase);
                        }
                    }
                    if (this.constVars.ignorePatWithLabeledNeigh && (prevTokenLabel || nextTokenLabel)) continue;
                    for (SurfacePattern s : prevnextPat) {
                        ((ClassicCounter)patternsandWords4Label.getCounter((Object)s)).incrementCount(longestMatchingPhrase);
                        ((ClassicCounter)posnegPatternsandWords4Label.getCounter((Object)s)).incrementCount(longestMatchingPhrase);
                        ((ClassicCounter)allPatternsandWords4Label.getCounter((Object)s)).incrementCount(longestMatchingPhrase);
                    }
                    continue;
                }
                boolean negToken = false;
                Map<Class, Object> ignore = this.constVars.ignoreWordswithClassesDuringSelection.get(label);
                for (Class igCl : ignore.keySet()) {
                    if (!((Boolean)token.get(igCl)).booleanValue()) continue;
                    negToken = true;
                    break;
                }
                if (!negToken && (this.constVars.getOtherSemanticClasses().contains(token.word()) || this.constVars.getOtherSemanticClasses().contains(token.lemma()))) {
                    negToken = true;
                }
                for (SurfacePattern s : CollectionUtils.union(CollectionUtils.union(prevPat, nextPat), prevnextPat)) {
                    if (negToken) {
                        ((ClassicCounter)negPatternsandWords4Label.getCounter((Object)s)).incrementCount(tokenWordOrLemma);
                        ((ClassicCounter)posnegPatternsandWords4Label.getCounter((Object)s)).incrementCount(tokenWordOrLemma);
                    } else {
                        ((ClassicCounter)unLabeledPatternsandWords4Label.getCounter((Object)s)).incrementCount(tokenWordOrLemma);
                    }
                    ((ClassicCounter)negandUnLabeledPatternsandWords4Label.getCounter((Object)s)).incrementCount(tokenWordOrLemma);
                    allPatternsandWords4Label.incrementCount(s, tokenWordOrLemma);
                }
            }
        }
    }

    private Set<SurfacePattern> enforceMinSupportRequirements(TwoDimensionalCounter<SurfacePattern, String> patternsandWords4Label, TwoDimensionalCounter<SurfacePattern, String> unLabeledPatternsandWords4Label) {
        HashSet<SurfacePattern> remove = new HashSet<SurfacePattern>();
        for (Map.Entry<SurfacePattern, ClassicCounter<String>> en : patternsandWords4Label.entrySet()) {
            if (en.getValue().size() >= this.constVars.minPosPhraseSupportForPat) continue;
            remove.add(en.getKey());
        }
        int numRemoved = remove.size();
        Redwood.log(new Object[]{Redwood.DBG, "Removing " + numRemoved + " patterns that do not meet minPosPhraseSupportForPat requirement of >= " + this.constVars.minPosPhraseSupportForPat});
        for (Map.Entry<SurfacePattern, ClassicCounter<String>> en : unLabeledPatternsandWords4Label.entrySet()) {
            if (en.getValue().size() >= this.constVars.minUnlabPhraseSupportForPat) continue;
            remove.add(en.getKey());
        }
        Redwood.log(new Object[]{Redwood.DBG, "Removing " + (remove.size() - numRemoved) + " patterns that do not meet minUnlabPhraseSupportForPat requirement of >= " + this.constVars.minUnlabPhraseSupportForPat});
        return remove;
    }

    void removeLearnedPattern(String label, SurfacePattern p) {
        this.learnedPatterns.get(label).remove(p);
        if (this.wordsPatExtracted.containsKey(label)) {
            for (Map.Entry<String, ClassicCounter<SurfacePattern>> en : this.wordsPatExtracted.get(label).entrySet()) {
                en.getValue().remove(p);
            }
        }
    }

    void removeLearnedPatterns(String label, Collection<SurfacePattern> pats) {
        Counters.removeKeys(this.learnedPatterns.get(label), pats);
        if (this.wordsPatExtracted.containsKey(label)) {
            for (Map.Entry<String, ClassicCounter<SurfacePattern>> en : this.wordsPatExtracted.get(label).entrySet()) {
                Counters.removeKeys(en.getValue(), pats);
            }
        }
    }

    public static Counter<String> normalizeSoftMaxMinMaxScores(Counter<String> scores, boolean minMaxNorm, boolean softmax, boolean oneMinusSoftMax) {
        double minScore = Double.MAX_VALUE;
        double maxScore = Double.MIN_VALUE;
        ClassicCounter<String> newscores = new ClassicCounter<String>();
        if (softmax) {
            for (Map.Entry<String, Double> entry : scores.entrySet()) {
                Double score = null;
                score = oneMinusSoftMax ? Double.valueOf(1.0 / (1.0 + Math.exp(Math.min(7.0, entry.getValue())))) : Double.valueOf(1.0 / (1.0 + Math.exp(-1.0 * Math.min(7.0, entry.getValue()))));
                if (score < minScore) {
                    minScore = score;
                }
                if (score > maxScore) {
                    maxScore = score;
                }
                newscores.setCount(entry.getKey(), score);
            }
        } else {
            newscores.addAll(scores);
            minScore = Counters.min(newscores);
            maxScore = Counters.max(newscores);
        }
        if (minMaxNorm) {
            for (Map.Entry<String, Double> entry : newscores.entrySet()) {
                double score = minScore == maxScore ? minScore : (entry.getValue() - minScore + 1.0E-10) / (maxScore - minScore);
                newscores.setCount(entry.getKey(), score);
            }
        }
        return newscores;
    }

    /*
     * Could not resolve type clashes
     */
    public void labelWords(String label, Map<String, List<CoreLabel>> sents, Set<String> identifiedWords, Set<SurfacePattern> patterns, String outFile, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>> matchedTokensByPat) throws IOException {
        int i;
        CollectionValuedMap tokensMatchedPatterns = null;
        if (this.constVars.restrictToMatched) {
            tokensMatchedPatterns = new CollectionValuedMap();
            for (Map.Entry<Object, Collection<Serializable>> en : matchedTokensByPat.entrySet()) {
                for (Triple en2 : en.getValue()) {
                    for (i = ((Integer)en2.second()).intValue(); i <= (Integer)en2.third(); ++i) {
                        tokensMatchedPatterns.add(en2.first(), i);
                    }
                }
            }
        }
        for (Map.Entry<Object, Collection<Serializable>> sentEn : sents.entrySet()) {
            HashSet<String[]> identifiedWordsTokens = new HashSet<String[]>();
            for (String s : identifiedWords) {
                String[] toks = s.split("\\s+");
                identifiedWordsTokens.add(toks);
            }
            Object[] sent = new String[((List)sentEn.getValue()).size()];
            i = 0;
            HashSet<Integer> contextWordsRecalculatePats = new HashSet<Integer>();
            for (CoreLabel l : (List)sentEn.getValue()) {
                sent[i] = l.word();
                ++i;
            }
            for (Object[] ph : identifiedWordsTokens) {
                List<Integer> ints = ArrayUtils.getSubListIndex(ph, sent);
                if (ints == null) continue;
                for (Integer idx : ints) {
                    int j;
                    boolean donotuse = false;
                    if (this.constVars.restrictToMatched) {
                        for (j = 0; j < ph.length; ++j) {
                            if (tokensMatchedPatterns.get(sentEn.getKey()).contains(idx + j)) continue;
                            Redwood.log(ConstantsAndVariables.extremedebug, "not labeling " + ((CoreLabel)((List)sentEn.getValue()).get(idx + j)).word());
                            donotuse = true;
                            break;
                        }
                    }
                    if (donotuse) continue;
                    for (j = 0; j < ph.length; ++j) {
                        int index = idx + j;
                        CoreLabel l = (CoreLabel)((List)sentEn.getValue()).get(index);
                        if (!this.constVars.usePatternResultAsLabel) continue;
                        l.set(this.constVars.answerClass.get(label), label);
                        HashSet<String> matched = new HashSet<String>();
                        matched.add(StringUtils.join(ph, " "));
                        l.set(PatternsAnnotations.MatchedPhrases.class, matched);
                        for (int k = Math.max(0, index - this.constVars.numWordsCompound); k < ((List)sentEn.getValue()).size() && k <= index + this.constVars.numWordsCompound + 1; ++k) {
                            contextWordsRecalculatePats.add(k);
                        }
                    }
                }
            }
            if (this.patternsForEachToken == null || !this.patternsForEachToken.containsKey(sentEn.getKey())) continue;
            Iterator i$ = contextWordsRecalculatePats.iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                this.patternsForEachToken.get(sentEn.getKey()).put(index, this.createPats.getContext((List)sentEn.getValue(), index));
            }
        }
        if (outFile != null) {
            Redwood.log(ConstantsAndVariables.minimaldebug, "Writing results to " + outFile);
            IOUtils.writeObjectToFile(sents, outFile);
        }
    }

    public void iterateExtractApply(Map<String, SurfacePattern> p0, Map<String, Counter<String>> p0Set, String wordsOutputFile, String sentsOutFile, String patternsOutFile, Map<String, Set<SurfacePattern>> ignorePatterns) throws ClassNotFoundException, IOException, InterruptedException, ExecutionException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        HashMap matchedTokensByPatAllLabels = new HashMap();
        HashMap termsAllLabels = new HashMap();
        HashMap ignoreWordsAll = new HashMap();
        for (String label : this.constVars.getLabelDictionary().keySet()) {
            matchedTokensByPatAllLabels.put(label, new CollectionValuedMap());
            termsAllLabels.put(label, new TwoDimensionalCounter());
            if (!this.constVars.useOtherLabelsWordsasNegative) continue;
            HashSet w = new HashSet();
            for (Map.Entry<String, Set<String>> en : this.constVars.getLabelDictionary().entrySet()) {
                if (en.getKey().equals(label)) continue;
                w.addAll(en.getValue());
            }
            ignoreWordsAll.put(label, w);
        }
        Redwood.log(ConstantsAndVariables.minimaldebug, "Iterating " + this.constVars.numIterationsForPatterns + " times.");
        HashMap<String, BufferedWriter> wordsOutput = new HashMap<String, BufferedWriter>();
        HashMap<String, BufferedWriter> patternsOutput = new HashMap<String, BufferedWriter>();
        for (String string : this.constVars.getLabelDictionary().keySet()) {
            IOUtils.ensureDir(new File(this.constVars.outDir + "/" + this.constVars.identifier + "/" + string));
            String wordsOutputFileLabel = wordsOutputFile + "_" + string;
            if (wordsOutputFile == null) {
                wordsOutputFileLabel = this.constVars.outDir + "/" + this.constVars.identifier + "/" + string + "/learnedwords.txt";
            }
            wordsOutput.put(string, new BufferedWriter(new FileWriter(wordsOutputFileLabel)));
            Redwood.log(ConstantsAndVariables.minimaldebug, "Saving the learned words for label " + string + " in " + wordsOutputFileLabel);
            String patternsOutputFileLabel = patternsOutFile + "_" + string;
            if (patternsOutFile == null) {
                patternsOutputFileLabel = this.constVars.outDir + "/" + this.constVars.identifier + "/" + string + "/learnedpatterns.txt";
            }
            patternsOutput.put(string, new BufferedWriter(new FileWriter(patternsOutputFileLabel)));
            Redwood.log(ConstantsAndVariables.minimaldebug, "Saving the learned patterns for label " + string + " in " + patternsOutputFileLabel);
        }
        for (int i = 0; i < this.constVars.numIterationsForPatterns; ++i) {
            boolean bl;
            Redwood.log(ConstantsAndVariables.minimaldebug, "\n\n################################ Iteration " + (i + 1) + " ##############################");
            boolean bl2 = false;
            HashMap<String, Counter<String>> learnedWordsThisIter = new HashMap<String, Counter<String>>();
            for (String label : this.constVars.getLabelDictionary().keySet()) {
                Redwood.log(ConstantsAndVariables.minimaldebug, "\n###Learning for label " + label + " ######");
                String sentout = sentsOutFile == null ? null : sentsOutFile + "_" + label;
                Pair<Counter<SurfacePattern>, Counter<String>> learnedPatWords4label = this.iterateExtractApply4Label(label, p0 != null ? p0.get(label) : null, p0Set != null ? p0Set.get(label) : null, (BufferedWriter)wordsOutput.get(label), sentout, (BufferedWriter)patternsOutput.get(label), ignorePatterns != null ? ignorePatterns.get(label) : null, 1, (Set)ignoreWordsAll.get(label), (CollectionValuedMap)matchedTokensByPatAllLabels.get(label), (TwoDimensionalCounter)termsAllLabels.get(label));
                learnedWordsThisIter.put(label, learnedPatWords4label.second());
                if (learnedPatWords4label.first().size() <= 0) continue;
                bl = true;
            }
            if (this.constVars.useOtherLabelsWordsasNegative) {
                for (String label : this.constVars.getLabelDictionary().keySet()) {
                    for (Map.Entry en : learnedWordsThisIter.entrySet()) {
                        if (((String)en.getKey()).equals(label)) continue;
                        ((Set)ignoreWordsAll.get(label)).addAll(((Counter)en.getValue()).keySet());
                    }
                }
            }
            if (bl) continue;
            if (!this.constVars.tuneThresholdKeepRunning) {
                Redwood.log(ConstantsAndVariables.minimaldebug, "No patterns learned for all labels. Ending iterations.");
                break;
            }
            this.constVars.thresholdSelectPattern = 0.8 * this.constVars.thresholdSelectPattern;
            Redwood.log(ConstantsAndVariables.minimaldebug, "\n\nTuning thresholds to keep running. New Pattern threshold is  " + this.constVars.thresholdSelectPattern);
        }
        if (this.constVars.outDir != null && !this.constVars.outDir.isEmpty()) {
            Redwood.log(ConstantsAndVariables.minimaldebug, "Writing justification files");
            HashSet allMatchedSents = new HashSet();
            for (String label : this.constVars.getLabelDictionary().keySet()) {
                CollectionValuedMap tokensMatchedPat = (CollectionValuedMap)matchedTokensByPatAllLabels.get(label);
                IOUtils.ensureDir(new File(this.constVars.outDir + "/" + this.constVars.identifier + "/" + label));
                if (!this.constVars.writeMatchedTokensFiles) continue;
                String matchedtokensfilename = this.constVars.outDir + "/" + this.constVars.identifier + "/" + label + "/tokensmatchedpatterns" + ".json";
                JsonObjectBuilder pats = Json.createObjectBuilder();
                for (Map.Entry en : tokensMatchedPat.entrySet()) {
                    CollectionValuedMap matchedStrs = new CollectionValuedMap();
                    for (Triple en2 : en.getValue()) {
                        allMatchedSents.add(en2.first());
                        matchedStrs.add(en2.first(), new Pair(en2.second(), en2.third()));
                    }
                    JsonObjectBuilder senttokens = Json.createObjectBuilder();
                    for (Map.Entry sen : matchedStrs.entrySet()) {
                        JsonArrayBuilder obj = Json.createArrayBuilder();
                        for (Pair sen2 : sen.getValue()) {
                            JsonArrayBuilder startend = Json.createArrayBuilder();
                            startend.add(((Integer)sen2.first()).intValue());
                            startend.add(((Integer)sen2.second()).intValue());
                            obj.add(startend);
                        }
                        senttokens.add((String)sen.getKey(), obj);
                    }
                    pats.add(((SurfacePattern)en.getKey()).toStringSimple(), senttokens);
                }
                IOUtils.writeStringToFile(pats.build().toString(), matchedtokensfilename, "utf8");
                JsonObjectBuilder senttokens = Json.createObjectBuilder();
                for (String sentId : allMatchedSents) {
                    JsonArrayBuilder sent = Json.createArrayBuilder();
                    for (CoreLabel l : Data.sents.get(sentId)) {
                        sent.add(l.word());
                    }
                    senttokens.add(sentId, sent);
                }
                String sentfilename = this.constVars.outDir + "/" + this.constVars.identifier + "/sentences" + ".json";
                IOUtils.writeStringToFile(senttokens.build().toString(), sentfilename, "utf8");
            }
        }
        System.out.println("\n\nAll patterns learned:");
        for (Map.Entry<String, Counter<SurfacePattern>> entry : this.learnedPatterns.entrySet()) {
            System.out.println(entry.getKey() + ":\t\t" + StringUtils.join(entry.getValue().keySet(), "\n") + "\n\n");
        }
        System.out.println("\n\nAll words learned:");
        for (Map.Entry<String, Counter<Object>> entry : this.learnedWords.entrySet()) {
            System.out.println(entry.getKey() + ":\t\t" + entry.getValue().keySet() + "\n\n");
        }
        for (String string : this.constVars.getLabelDictionary().keySet()) {
            ((BufferedWriter)wordsOutput.get(string)).close();
            ((BufferedWriter)patternsOutput.get(string)).close();
        }
    }

    public Pair<Counter<SurfacePattern>, Counter<String>> iterateExtractApply4Label(String label, SurfacePattern p0, Counter<String> p0Set, BufferedWriter wordsOutput, String sentsOutFile, BufferedWriter patternsOut, Set<SurfacePattern> ignorePatterns, int numIter, Set<String> ignoreWords, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>> matchedTokensByPat, TwoDimensionalCounter<String, SurfacePattern> terms) throws IOException, InterruptedException, ExecutionException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (!this.learnedPatterns.containsKey(label)) {
            this.learnedPatterns.put(label, new ClassicCounter());
        }
        if (!this.learnedWords.containsKey(label)) {
            this.learnedWords.put(label, new ClassicCounter());
        }
        ClassicCounter<String> identifiedWords = new ClassicCounter<String>();
        ClassicCounter<SurfacePattern> patterns = new ClassicCounter<SurfacePattern>();
        for (int i = 0; i < numIter; ++i) {
            patterns.addAll(this.getPatterns(label, this.learnedPatterns.get(label).keySet(), p0, p0Set, ignorePatterns));
            this.learnedPatterns.get(label).addAll(patterns);
            if (sentsOutFile != null) {
                sentsOutFile = sentsOutFile + "_" + i + "iter.ser";
            }
            ClassicCounter<String> scoreForAllWordsThisIteration = new ClassicCounter<String>();
            identifiedWords.addAll(this.scorePhrases.learnNewPhrases(label, this.patternsForEachToken, patterns, this.learnedPatterns.get(label), matchedTokensByPat, scoreForAllWordsThisIteration, terms, this.wordsPatExtracted.get(label), this.currentPatternWeights.get(label), this.patternsandWords.get(label), this.allPatternsandWords.get(label), this.constVars.identifier, ignoreWords));
            if (identifiedWords.size() > 0) {
                if (this.constVars.usePatternResultAsLabel) {
                    if (this.constVars.getLabelDictionary().containsKey(label)) {
                        if (this.constVars.batchProcessSents) {
                            for (File f : Data.sentsFiles) {
                                Redwood.log(new Object[]{Redwood.DBG, "labeling sentences from " + f});
                                Map sents = (Map)IOUtils.readObjectFromFile(f);
                                this.labelWords(label, sents, identifiedWords.keySet(), patterns.keySet(), sentsOutFile, matchedTokensByPat);
                                IOUtils.writeObjectToFile((Object)sents, f);
                            }
                        } else {
                            this.labelWords(label, Data.sents, identifiedWords.keySet(), patterns.keySet(), sentsOutFile, matchedTokensByPat);
                        }
                    } else {
                        throw new RuntimeException("why is the answer label null?");
                    }
                    this.learnedWords.get(label).addAll(identifiedWords);
                }
                if (wordsOutput != null) {
                    wordsOutput.write("\n" + Counters.toSortedString(identifiedWords, identifiedWords.size(), "%1$s", "\n"));
                    wordsOutput.flush();
                }
            }
            if (patterns.size() != 0 || identifiedWords.size() != 0) continue;
            if (this.learnedWords.get(label).size() >= this.constVars.maxExtractNumWords) {
                System.out.println("Ending because no new words identified and total words learned till now >= max words " + this.constVars.maxExtractNumWords);
                break;
            }
            if (!this.constVars.tuneThresholdKeepRunning) break;
            this.constVars.thresholdSelectPattern = 0.8 * this.constVars.thresholdSelectPattern;
            System.out.println("\n\nTuning thresholds to keep running. New Pattern threshold is  " + this.constVars.thresholdSelectPattern);
        }
        if (patternsOut != null) {
            this.writePatternsToFile(this.learnedPatterns.get(label), patternsOut);
        }
        return new Pair<Counter<SurfacePattern>, Counter<String>>(patterns, identifiedWords);
    }

    void writePatternsToFile(Counter<SurfacePattern> pattern, BufferedWriter outFile) throws IOException {
        for (Map.Entry<SurfacePattern, Double> en : pattern.entrySet()) {
            outFile.write(en.getKey().toString() + "\t" + en.getValue() + "\n");
        }
    }

    void writeWordsToFile(Counter<String> words, BufferedWriter outFile) throws IOException {
        for (Map.Entry<String, Double> en : words.entrySet()) {
            outFile.write(en.getKey() + "\t" + en.getValue() + "\n");
        }
    }

    Counter<String> readLearnedWordsFromFile(File file) {
        ClassicCounter<String> words = new ClassicCounter<String>();
        for (String line : IOUtils.readLines(file)) {
            String[] t = line.split("\t");
            words.setCount(t[0], Double.parseDouble(t[1]));
        }
        return words;
    }

    public Counter<String> getLearnedWords(String label) {
        return this.learnedWords.get(label);
    }

    public Counter<SurfacePattern> getLearnedPatterns(String label) {
        return this.learnedPatterns.get(label);
    }

    public void setLearnedWords(Counter<String> words, String label) {
        this.learnedWords.put(label, words);
    }

    public void setLearnedPatterns(Counter<SurfacePattern> patterns, String label) {
        this.learnedPatterns.put(label, patterns);
    }

    public static boolean countResultsPerEntity(List<CoreLabel> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN, String background, Counter<String> wordTP, Counter<String> wordTN, Counter<String> wordFP, Counter<String> wordFN, Class<? extends TypesafeMap.Key<String>> whichClassToCompare) {
        int index = 0;
        int goldIndex = 0;
        int guessIndex = 0;
        String lastGold = background;
        String lastGuess = background;
        String str = "";
        String s = "";
        for (CoreLabel l : doc) {
            s = s + " " + l.word() + ":" + (String)l.get(CoreAnnotations.GoldAnswerAnnotation.class) + ":" + (String)l.get(whichClassToCompare);
        }
        for (CoreLabel line : doc) {
            String gold = (String)line.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String guess = (String)line.get(whichClassToCompare);
            if (gold == null || guess == null) {
                return false;
            }
            if (lastGold != null && !lastGold.equals(gold) && !lastGold.equals(background)) {
                if (lastGuess.equals(lastGold) && !lastGuess.equals(guess) && goldIndex == guessIndex) {
                    wordTP.incrementCount(str);
                    entityTP.incrementCount(lastGold, 1.0);
                } else {
                    wordFN.incrementCount(str);
                    entityFN.incrementCount(lastGold, 1.0);
                    str = "";
                }
            }
            if (lastGuess != null && !lastGuess.equals(guess) && !lastGuess.equals(background)) {
                if (!lastGuess.equals(lastGold) || lastGuess.equals(guess) || goldIndex != guessIndex || lastGold.equals(gold)) {
                    entityFP.incrementCount(lastGuess, 1.0);
                    wordFP.incrementCount(str);
                }
                str = "";
            }
            if (lastGuess != null && lastGold != null && lastGold.equals(background) && lastGuess.equals(background)) {
                str = "";
            }
            if (lastGold == null || !lastGold.equals(gold)) {
                lastGold = gold;
                goldIndex = index;
            }
            if (lastGuess == null || !lastGuess.equals(guess)) {
                lastGuess = guess;
                guessIndex = index;
            }
            ++index;
            if (str.isEmpty()) {
                str = line.word();
                continue;
            }
            str = str + " " + line.word();
        }
        if (lastGold != null && !lastGold.equals(background)) {
            if (lastGold.equals(lastGuess) && goldIndex == guessIndex) {
                entityTP.incrementCount(lastGold, 1.0);
                wordTP.incrementCount(str);
            } else {
                entityFN.incrementCount(lastGold, 1.0);
                wordFN.incrementCount(str);
            }
            str = "";
        }
        if (lastGuess != null && !lastGuess.equals(background)) {
            if (!lastGold.equals(lastGuess) || goldIndex != guessIndex) {
                entityFP.incrementCount(lastGuess, 1.0);
                wordFP.incrementCount(str);
            }
            str = "";
        }
        return true;
    }

    public static void countResultsPerToken(List<CoreLabel> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN, String background, Counter<String> wordTP, Counter<String> wordTN, Counter<String> wordFP, Counter<String> wordFN, Class<? extends TypesafeMap.Key<String>> whichClassToCompare) {
        CRFClassifier.countResults(doc, entityTP, entityFP, entityFN, background);
        for (CoreLabel line : doc) {
            String gold = (String)line.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String guess = (String)line.get(whichClassToCompare);
            if (gold == null || guess == null) {
                throw new RuntimeException("why is gold or guess null?");
            }
            if (gold.equals(guess) && !gold.equalsIgnoreCase(background)) {
                entityTP.incrementCount(gold);
                wordTP.incrementCount(line.word());
                continue;
            }
            if (!gold.equals(guess) && !gold.equalsIgnoreCase(background) && guess.equalsIgnoreCase(background)) {
                entityFN.incrementCount(gold);
                wordFN.incrementCount(line.word());
                continue;
            }
            if (!gold.equals(guess) && !guess.equalsIgnoreCase(background) && gold.equalsIgnoreCase(background)) {
                wordFP.incrementCount(line.word());
                entityFP.incrementCount(guess);
                continue;
            }
            if (gold.equals(guess) && !gold.equalsIgnoreCase(background)) {
                wordTN.incrementCount(line.word());
                continue;
            }
            if (gold.equalsIgnoreCase(background) && guess.equalsIgnoreCase(background)) continue;
            throw new RuntimeException("don't know reached here. not meant for more than one entity label");
        }
    }

    public static void countResults(List<CoreLabel> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN, String background, Counter<String> wordTP, Counter<String> wordTN, Counter<String> wordFP, Counter<String> wordFN, Class<? extends TypesafeMap.Key<String>> whichClassToCompare, boolean evalPerEntity) {
        if (evalPerEntity) {
            GetPatternsFromDataMultiClass.countResultsPerEntity(doc, entityTP, entityFP, entityFN, background, wordTP, wordTN, wordFP, wordFN, whichClassToCompare);
        } else {
            GetPatternsFromDataMultiClass.countResultsPerToken(doc, entityTP, entityFP, entityFN, background, wordTP, wordTN, wordFP, wordFN, whichClassToCompare);
        }
    }

    private void writeLabelDataSents(Map<String, List<CoreLabel>> sents, BufferedWriter writer) throws IOException {
        for (Map.Entry<String, List<CoreLabel>> sent : sents.entrySet()) {
            writer.write(sent.getKey() + "\t");
            HashMap<String, Boolean> lastWordLabeled = new HashMap<String, Boolean>();
            for (String label : this.constVars.getLabelDictionary().keySet()) {
                lastWordLabeled.put(label, false);
            }
            for (CoreLabel s : sent.getValue()) {
                String str = "";
                ArrayList<String> listEndedLabels = new ArrayList<String>();
                ArrayList<String> startingLabels = new ArrayList<String>();
                for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> as : this.constVars.answerClass.entrySet()) {
                    String label = as.getKey();
                    boolean lastwordlabeled = (Boolean)lastWordLabeled.get(label);
                    if (((String)s.get(as.getValue())).equals(label)) {
                        if (!lastwordlabeled) {
                            startingLabels.add(label);
                        }
                        lastWordLabeled.put(label, true);
                        continue;
                    }
                    if (lastwordlabeled) {
                        listEndedLabels.add(label);
                    }
                    lastWordLabeled.put(label, false);
                }
                for (int i = listEndedLabels.size() - 1; i >= 0; --i) {
                    str = str + " </" + (String)listEndedLabels.get(i) + ">";
                }
                for (String label : startingLabels) {
                    str = str + " <" + label + "> ";
                }
                str = str + " " + s.word();
                writer.write(str.trim() + " ");
            }
            writer.write("\n");
        }
    }

    public void writeLabeledData(String outFile) throws IOException, ClassNotFoundException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        if (!this.constVars.batchProcessSents) {
            this.writeLabelDataSents(Data.sents, writer);
        } else {
            for (File f : Data.sentsFiles) {
                Map sents = (Map)IOUtils.readObjectFromFile(f);
                this.writeLabelDataSents(sents, writer);
            }
        }
        writer.close();
    }

    public void evaluate(Map<String, List<CoreLabel>> testSentences, boolean evalPerEntity) throws IOException {
        for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> anscl : this.constVars.answerClass.entrySet()) {
            String label = anscl.getKey();
            ClassicCounter<String> entityTP = new ClassicCounter<String>();
            ClassicCounter<String> entityFP = new ClassicCounter<String>();
            ClassicCounter<String> entityFN = new ClassicCounter<String>();
            ClassicCounter<String> wordTP = new ClassicCounter<String>();
            ClassicCounter<String> wordTN = new ClassicCounter<String>();
            ClassicCounter<String> wordFP = new ClassicCounter<String>();
            ClassicCounter<String> wordFN = new ClassicCounter<String>();
            for (Map.Entry<String, List<CoreLabel>> docEn : testSentences.entrySet()) {
                List<CoreLabel> doc = docEn.getValue();
                ArrayList<CoreLabel> doceval = new ArrayList<CoreLabel>();
                for (CoreLabel l : doc) {
                    CoreLabel l2 = new CoreLabel();
                    l2.setWord(l.word());
                    if (((String)l.get(anscl.getValue())).equals(label)) {
                        l2.set(CoreAnnotations.AnswerAnnotation.class, label);
                    } else {
                        l2.set(CoreAnnotations.AnswerAnnotation.class, this.constVars.backgroundSymbol);
                    }
                    if (!((String)l.get(CoreAnnotations.GoldAnswerAnnotation.class)).equals(label)) {
                        l2.set(CoreAnnotations.GoldAnswerAnnotation.class, this.constVars.backgroundSymbol);
                    } else {
                        l2.set(CoreAnnotations.GoldAnswerAnnotation.class, label);
                    }
                    doceval.add(l2);
                }
                GetPatternsFromDataMultiClass.countResults(doceval, entityTP, entityFP, entityFN, this.constVars.backgroundSymbol, wordTP, wordTN, wordFP, wordFN, CoreAnnotations.AnswerAnnotation.class, evalPerEntity);
            }
            System.out.println("False Positives: " + Counters.toSortedString(wordFP, wordFP.size(), "%s:%.2f", ";"));
            System.out.println("False Negatives: " + Counters.toSortedString(wordFN, wordFN.size(), "%s:%.2f", ";"));
            Redwood.log(new Object[]{Redwood.DBG, "\nFor label " + label + " True Positives: " + entityTP + "\tFalse Positives: " + entityFP + "\tFalse Negatives: " + entityFN});
            Counter<String> precision = Counters.division(entityTP, Counters.add(entityTP, entityFP));
            Counter<String> recall = Counters.division(entityTP, Counters.add(entityTP, entityFN));
            Redwood.log(ConstantsAndVariables.minimaldebug, "\nFor label " + label + " Precision: " + precision + ", Recall: " + recall + ", F1 score:  " + GetPatternsFromDataMultiClass.FScore(precision, recall, 1.0));
        }
    }

    public static <D> Counter<D> FScore(Counter<D> precision, Counter<D> recall, double beta) {
        double betasq = beta * beta;
        return Counters.divisionNonNaN(Counters.scale(Counters.product(precision, recall), 1.0 + betasq), Counters.add(Counters.scale(precision, betasq), recall));
    }

    public static List<File> getAllFiles(String file) {
        ArrayList<File> allFiles = new ArrayList<File>();
        for (String tokfile : file.split("[,;]")) {
            File filef = new File(tokfile);
            if (filef.isDirectory()) {
                String path = ".*";
                File dir = filef;
                for (File f : IOUtils.iterFilesRecursive(dir, Pattern.compile(path))) {
                    Redwood.log(new Object[]{Redwood.DBG, "Reading file " + f});
                    allFiles.add(f);
                }
                continue;
            }
            Redwood.log(new Object[]{Redwood.DBG, "Reading file " + filef});
            allFiles.add(filef);
        }
        return allFiles;
    }

    private Pair<Double, Double> getPrecisionRecall(String label, Map<String, Boolean> goldWords4Label) {
        Set<String> learnedWords = this.getLearnedWords(label).keySet();
        int numcorrect = 0;
        int numincorrect = 0;
        int numgoldcorrect = 0;
        for (Map.Entry<String, Boolean> en : goldWords4Label.entrySet()) {
            if (!en.getValue().booleanValue()) continue;
            ++numgoldcorrect;
        }
        HashSet<String> assumedNeg = new HashSet<String>();
        for (String e : learnedWords) {
            if (!goldWords4Label.containsKey(e)) {
                assumedNeg.add(e);
                ++numincorrect;
                continue;
            }
            if (goldWords4Label.get(e).booleanValue()) {
                ++numcorrect;
                continue;
            }
            ++numincorrect;
        }
        if (!assumedNeg.isEmpty()) {
            System.err.println("Gold entity list does not contain words " + assumedNeg + " for label " + label + ". Assuming them as negative.");
        }
        double precision = (double)numcorrect / (double)(numcorrect + numincorrect);
        double recall = (double)numcorrect / (double)numgoldcorrect;
        return new Pair<Double, Double>(precision, recall);
    }

    public double FScore(double precision, double recall, double beta) {
        double betasq = beta * beta;
        return (1.0 + betasq) * precision * recall / (betasq * precision + recall);
    }

    public static void main(String[] args) {
        try {
            boolean savePatternsWordsDir;
            Properties props = StringUtils.argsToPropertiesWithResolve(args);
            HashMap<String, Set<SurfacePattern>> ignorePatterns = new HashMap<String, Set<SurfacePattern>>();
            HashMap<String, SurfacePattern> p0 = new HashMap<String, SurfacePattern>();
            HashMap<String, Counter<String>> p0Set = new HashMap<String, Counter<String>>();
            String fileFormat = props.getProperty("fileFormat");
            HashMap<String, Set<String>> seedWords = new HashMap<String, Set<String>>();
            String seedWordsFiles = props.getProperty("seedWordsFiles");
            if (seedWordsFiles == null) {
                throw new RuntimeException("Needs both seedWordsFiles and file parameters to run this class!\nseedWordsFiles has format: label1,filewithlistofwords1;label2,filewithlistofwords2;...");
            }
            for (String seedFile : seedWordsFiles.split(";")) {
                String[] t = seedFile.split(",");
                String label = t[0];
                String seedWordsFile = t[1];
                HashSet<String> seedWords4Label = new HashSet<String>();
                for (String line : IOUtils.readLines(seedWordsFile)) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    seedWords4Label.add(line);
                }
                seedWords.put(label, seedWords4Label);
                Redwood.log(ConstantsAndVariables.minimaldebug, "Number of seed words for label " + label + " is " + seedWords4Label.size());
            }
            HashMap answerClasses = new HashMap();
            String ansClasses = props.getProperty("answerClasses");
            if (ansClasses != null) {
                for (String l : ansClasses.split(";")) {
                    String[] t = l.split(",");
                    String label = t[0];
                    String cl = t[1];
                    Class<?> answerClass = ClassLoader.getSystemClassLoader().loadClass(cl);
                    answerClasses.put(label, answerClass);
                }
            }
            HashMap<String, List<CoreLabel>> sents = null;
            boolean batchProcessSents = Boolean.parseBoolean(props.getProperty("batchProcessSents", "false"));
            int numMaxSentencesPerBatchFile = Integer.parseInt(props.getProperty("numMaxSentencesPerBatchFile", String.valueOf(Integer.MAX_VALUE)));
            if (!batchProcessSents) {
                sents = new HashMap<String, List<CoreLabel>>();
            } else {
                Data.sentsFiles = new ArrayList<File>();
            }
            String file = props.getProperty("file");
            String posModelPath = props.getProperty("posModelPath");
            boolean lowercase = Boolean.parseBoolean(props.getProperty("lowercaseText"));
            boolean useTargetNERRestriction = Boolean.parseBoolean(props.getProperty("useTargetNERRestriction"));
            boolean useTargetParserParentRestriction = Boolean.parseBoolean(props.getProperty("useTargetParserParentRestriction"));
            boolean useContextNERRestriction = Boolean.parseBoolean(props.getProperty("useContextNERRestriction"));
            boolean evaluate = Boolean.parseBoolean(props.getProperty("evaluate"));
            boolean addEvalSentsToTrain = Boolean.parseBoolean(props.getProperty("addEvalSentsToTrain"));
            String evalFileWithGoldLabels = props.getProperty("evalFileWithGoldLabels");
            if (!(file != null || evalFileWithGoldLabels != null && addEvalSentsToTrain)) {
                throw new RuntimeException("No training data! file is " + file + " and evalFileWithGoldLabels is " + evalFileWithGoldLabels + " and addEvalSentsToTrain is " + addEvalSentsToTrain);
            }
            String saveSentencesSerDir = null;
            boolean usingDirForSentsInIndex = true;
            if (file != null) {
                saveSentencesSerDir = props.getProperty("saveSentencesSerDir");
                File saveSentencesSerDirFile = null;
                if (saveSentencesSerDir != null) {
                    saveSentencesSerDirFile = new File(saveSentencesSerDir);
                    IOUtils.ensureDir(saveSentencesSerDirFile);
                    IOUtils.writeObjectToFile(sents, saveSentencesSerDir + "/sents_all.ser");
                } else {
                    String systemdir = System.getProperty("java.io.tmpdir");
                    saveSentencesSerDirFile = File.createTempFile("sents", ".tmp", new File(systemdir));
                    saveSentencesSerDirFile.deleteOnExit();
                    saveSentencesSerDir = saveSentencesSerDirFile.getAbsolutePath();
                    saveSentencesSerDirFile.delete();
                    saveSentencesSerDirFile.mkdir();
                }
                List<File> allFiles = GetPatternsFromDataMultiClass.getAllFiles(file);
                int numFilesTillNow = 0;
                if (fileFormat == null || fileFormat.equalsIgnoreCase("text") || fileFormat.equalsIgnoreCase("txt")) {
                    HashMap<String, List<CoreLabel>> sentsthis = new HashMap<String, List<CoreLabel>>();
                    for (File f : allFiles) {
                        Redwood.log(new Object[]{Redwood.DBG, "Annotating text in " + f});
                        String text = IOUtils.stringFromFile(f.getAbsolutePath());
                        numFilesTillNow = GetPatternsFromDataMultiClass.tokenize(text, posModelPath, lowercase, useTargetNERRestriction || useContextNERRestriction, f.getName() + "-", useTargetParserParentRestriction, props.getProperty("numThreads"), batchProcessSents, numMaxSentencesPerBatchFile, saveSentencesSerDirFile, sentsthis, numFilesTillNow);
                        if (batchProcessSents) continue;
                        sents.putAll(sentsthis);
                    }
                    if (!batchProcessSents) {
                        IOUtils.writeObjectToFile(sents, saveSentencesSerDirFile + "/sents_" + numFilesTillNow);
                    }
                } else if (fileFormat.equalsIgnoreCase("ser")) {
                    usingDirForSentsInIndex = false;
                    for (File f : allFiles) {
                        if (!batchProcessSents) {
                            sents.putAll((Map)IOUtils.readObjectFromFile(f));
                            continue;
                        }
                        File newf = new File(saveSentencesSerDir + "/" + f.getAbsolutePath().replaceAll(Pattern.quote("/"), "_"));
                        IOUtils.cp(f, newf);
                        Data.sentsFiles.add(newf);
                    }
                } else {
                    throw new RuntimeException("Cannot identify the file format. Valid values are text (or txt) and ser, where the serialized file is of the type Map<String, List<CoreLabel>>.");
                }
            }
            HashMap<String, List<CoreLabel>> evalsents = new HashMap<String, List<CoreLabel>>();
            File saveEvalSentencesSerFileFile = null;
            if (evaluate && evalFileWithGoldLabels != null) {
                String saveEvalSentencesSerFile = props.getProperty("saveEvalSentencesSerFile");
                if (saveEvalSentencesSerFile == null) {
                    String systemdir = System.getProperty("java.io.tmpdir");
                    saveEvalSentencesSerFileFile = File.createTempFile("evalsents", ".tmp", new File(systemdir));
                } else {
                    saveEvalSentencesSerFileFile = new File(saveEvalSentencesSerFile);
                }
                HashMap<String, Class<? extends TypesafeMap.Key<String>>> setClassForTheseLabels = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
                boolean splitOnPunct = Boolean.parseBoolean(props.getProperty("splitOnPunct", "true"));
                List<File> allFiles = GetPatternsFromDataMultiClass.getAllFiles(evalFileWithGoldLabels);
                int numFile = 0;
                String evalFileFormat = props.getProperty("evalFileFormat");
                if (evalFileFormat == null || evalFileFormat.equalsIgnoreCase("text") || evalFileFormat.equalsIgnoreCase("txt")) {
                    for (File f : allFiles) {
                        Redwood.log(new Object[]{Redwood.DBG, "Annotating text in " + f + ". Num file " + ++numFile});
                        List<CoreMap> sentsCMs = AnnotatedTextReader.parseFile(new BufferedReader(new FileReader(f)), seedWords.keySet(), setClassForTheseLabels, true, splitOnPunct, lowercase, f.getName());
                        evalsents.putAll(GetPatternsFromDataMultiClass.runPOSNEROnTokens(sentsCMs, posModelPath, useTargetNERRestriction || useContextNERRestriction, "", useTargetParserParentRestriction, props.getProperty("numThreads")));
                    }
                } else if (fileFormat.equalsIgnoreCase("ser")) {
                    for (File f : allFiles) {
                        evalsents.putAll((Map)IOUtils.readObjectFromFile(f));
                    }
                }
                Redwood.log(new Object[]{Redwood.DBG, "Adding " + evalsents.size() + " eval sents to the training set"});
                IOUtils.writeObjectToFile(evalsents, saveEvalSentencesSerFileFile);
                if (batchProcessSents) {
                    if (Data.sentsFiles == null) {
                        Data.sentsFiles = new ArrayList<File>();
                    }
                    Data.sentsFiles.add(saveEvalSentencesSerFileFile);
                } else {
                    sents.putAll(evalsents);
                }
            }
            boolean learn = Boolean.parseBoolean(props.getProperty("learn", "true"));
            boolean labelUsingSeedSets = Boolean.parseBoolean(props.getProperty("labelUsingSeedSets", "true"));
            GetPatternsFromDataMultiClass model = new GetPatternsFromDataMultiClass(props, sents, seedWords, labelUsingSeedSets);
            model.constVars.usingDirForSentsInIndex = usingDirForSentsInIndex;
            model.constVars.saveSentencesSerDir = saveSentencesSerDir;
            Execution.fillOptions((Object)model, props);
            String sentsOutFile = props.getProperty("sentsOutFile");
            String wordsOutputFile = props.getProperty("wordsOutputFile");
            String patternOutFile = props.getProperty("patternOutFile");
            boolean loadSavedPatternsWordsDir = Boolean.parseBoolean(props.getProperty("loadSavedPatternsWordsDir"));
            String patternsWordsDir = props.getProperty("patternsWordsDir");
            if (loadSavedPatternsWordsDir) {
                for (String label : model.constVars.getLabelDictionary().keySet()) {
                    File wordf;
                    assert (new File(patternsWordsDir + "/" + label).exists());
                    File patf = new File(patternsWordsDir + "/" + label + "/patterns.ser");
                    if (patf.exists()) {
                        Counter patterns = (Counter)IOUtils.readObjectFromFile(patf);
                        model.setLearnedPatterns(patterns, label);
                        Redwood.log(new Object[]{Redwood.DBG, "Loaded " + patterns.size() + " patterns from " + patf});
                    }
                    if ((wordf = new File(patternsWordsDir + "/" + label + "/phrases.txt")).exists()) {
                        Counter<String> words = model.readLearnedWordsFromFile(wordf);
                        model.setLearnedWords(words, label);
                        Redwood.log(new Object[]{Redwood.DBG, "Loaded " + words.size() + " from " + patf});
                    }
                    CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>> matchedTokensByPat = null;
                    if (model.constVars.restrictToMatched) {
                        TwoDimensionalCounter<Pair<String, String>, SurfacePattern> wordsandLemmaPatExtracted = new TwoDimensionalCounter<Pair<String, String>, SurfacePattern>();
                        model.scorePhrases.applyPats(model.getLearnedPatterns(label), label, false, wordsandLemmaPatExtracted, matchedTokensByPat);
                    }
                    if (model.constVars.batchProcessSents) {
                        for (File f : Data.sentsFiles) {
                            Redwood.log(new Object[]{Redwood.DBG, "labeling sentences from " + f + " with the already learned words"});
                            Map sentsf = (Map)IOUtils.readObjectFromFile(f);
                            assert (sentsf != null) : "Why are sents null";
                            model.labelWords(label, sentsf, model.getLearnedWords(label).keySet(), model.getLearnedPatterns(label).keySet(), sentsOutFile, matchedTokensByPat);
                            IOUtils.writeObjectToFile((Object)sentsf, f);
                        }
                        continue;
                    }
                    model.labelWords(label, Data.sents, model.getLearnedWords(label).keySet(), model.getLearnedPatterns(label).keySet(), sentsOutFile, matchedTokensByPat);
                }
            }
            if (learn) {
                model.iterateExtractApply(p0, p0Set, wordsOutputFile, sentsOutFile, patternOutFile, ignorePatterns);
            }
            if (model.constVars.markedOutputTextFile != null) {
                model.writeLabeledData(model.constVars.markedOutputTextFile);
            }
            if (savePatternsWordsDir = Boolean.parseBoolean(props.getProperty("savePatternsWordsDir"))) {
                for (String label : model.constVars.getLabelDictionary().keySet()) {
                    IOUtils.ensureDir(new File(patternsWordsDir + "/" + label));
                    IOUtils.writeObjectToFile(model.getLearnedPatterns(label), patternsWordsDir + "/" + label + "/patterns.ser");
                    BufferedWriter w = new BufferedWriter(new FileWriter(patternsWordsDir + "/" + label + "/phrases.txt"));
                    model.writeWordsToFile(model.getLearnedWords(label), w);
                    w.close();
                }
            }
            if (evaluate) {
                String goldEntitiesEvalFiles = props.getProperty("goldEntitiesEvalFiles");
                if (goldEntitiesEvalFiles != null) {
                    for (String gfile : goldEntitiesEvalFiles.split(";")) {
                        String[] t = gfile.split(",");
                        String label = t[0];
                        String goldfile = t[1];
                        HashMap<String, Boolean> goldWords4Label = new HashMap<String, Boolean>();
                        for (String line : IOUtils.readLines(goldfile)) {
                            if ((line = line.trim()).isEmpty()) continue;
                            if (line.endsWith("#")) {
                                goldWords4Label.put(line.substring(0, line.length() - 1), false);
                                continue;
                            }
                            goldWords4Label.put(line, true);
                        }
                        Pair<Double, Double> pr = model.getPrecisionRecall(label, goldWords4Label);
                        Redwood.log(ConstantsAndVariables.minimaldebug, "\nFor label " + label + ": Number of gold entities is " + goldWords4Label.size() + ", Precision is " + model.df.format(pr.first() * 100.0) + ", Recall is " + model.df.format(pr.second() * 100.0) + ", F1 is " + model.df.format(model.FScore(pr.first(), pr.second(), 1.0) * 100.0) + "\n\n");
                    }
                }
                if (saveEvalSentencesSerFileFile != null && saveEvalSentencesSerFileFile.exists()) {
                    if (batchProcessSents) {
                        evalsents = (Map)IOUtils.readObjectFromFile(saveEvalSentencesSerFileFile);
                    }
                    boolean evalPerEntity = Boolean.parseBoolean(props.getProperty("evalPerEntity", "true"));
                    model.evaluate(evalsents, evalPerEntity);
                }
                if (evalsents.size() == 0 && goldEntitiesEvalFiles == null) {
                    System.err.println("No eval sentences or list of gold entities provided to evaluate! Make sure evalFileWithGoldLabels or goldEntitiesEvalFiles is set, or turn off the evaluate flag");
                }
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("Out of memory! Either change the memory alloted by running as java -mx20g ... for example if you want to allot 20G. Or consider using batchProcessSents and numMaxSentencesPerBatchFile flags");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class LabelWithSeedWords
    implements Callable<Map<String, List<CoreLabel>>> {
        Set<String[]> seedwordsTokens = new HashSet<String[]>();
        Map<String, List<CoreLabel>> sents;
        List<String> keyset;
        Class labelClass;
        HashSet<String> seenFuzzyMatches = new HashSet();
        String label;
        int minLen4FuzzyForPattern;
        String backgroundSymbol = "O";
        Set<String> dictWords = null;

        public LabelWithSeedWords(Set<String> seedwords, Map<String, List<CoreLabel>> sents, List<String> keyset, Class labelclass, String label, int minLen4FuzzyForPattern, String backgroundSymbol, Set<String> dictWords) {
            for (String s : seedwords) {
                this.seedwordsTokens.add(s.split("\\s+"));
            }
            this.sents = sents;
            this.keyset = keyset;
            this.labelClass = labelclass;
            this.label = label;
            this.minLen4FuzzyForPattern = minLen4FuzzyForPattern;
            this.backgroundSymbol = backgroundSymbol;
            this.dictWords = dictWords;
        }

        @Override
        public Map<String, List<CoreLabel>> call() throws Exception {
            HashMap<String, List<CoreLabel>> newsent = new HashMap<String, List<CoreLabel>>();
            for (String k : this.keyset) {
                List<CoreLabel> sent = this.sents.get(k);
                String[] tokens = new String[sent.size()];
                String[] tokenslemma = new String[sent.size()];
                int num = 0;
                for (CoreLabel l : sent) {
                    tokens[num] = l.word();
                    if (l.lemma() == null) {
                        throw new RuntimeException("how come lemma is null");
                    }
                    tokenslemma[num] = l.lemma();
                    ++num;
                }
                boolean[] labels = new boolean[tokens.length];
                CollectionValuedMap<Integer, String> matchedPhrases = new CollectionValuedMap<Integer, String>();
                for (Object[] objectArray : this.seedwordsTokens) {
                    List<Integer> indices = GetPatternsFromDataMultiClass.getSubListIndex((String[])objectArray, tokens, tokenslemma, this.dictWords, this.seenFuzzyMatches, this.minLen4FuzzyForPattern);
                    if (indices == null || indices.isEmpty()) continue;
                    for (int index : indices) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            matchedPhrases.add(index + i, StringUtils.join(objectArray, " "));
                            labels[index + i] = true;
                        }
                    }
                }
                int i = -1;
                for (CoreLabel l : sent) {
                    if (labels[++i]) {
                        l.set(this.labelClass, this.label);
                        Redwood.log(ConstantsAndVariables.extremedebug, "labeling " + l.word() + " or its lemma " + l.lemma() + " as " + this.label + " because of the dict phrases " + (Set)matchedPhrases.get(i));
                    } else {
                        l.set(this.labelClass, this.backgroundSymbol);
                    }
                    if (!l.containsKey(PatternsAnnotations.MatchedPhrases.class)) {
                        l.set(PatternsAnnotations.MatchedPhrases.class, new HashSet());
                    }
                    ((Set)l.get(PatternsAnnotations.MatchedPhrases.class)).addAll(matchedPhrases.get(i));
                }
                newsent.put(k, sent);
            }
            return newsent;
        }
    }

    static enum WordScoring {
        BPB,
        WEIGHTEDNORM;

    }

    public static enum PatternScoring {
        F1SeedPattern,
        RlogF,
        RlogFPosNeg,
        RlogFUnlabNeg,
        RlogFNeg,
        PhEvalInPat,
        PhEvalInPatLogP,
        PosNegOdds,
        YanGarber02,
        PosNegUnlabOdds,
        RatioAll,
        LOGREG,
        LOGREGlogP,
        SqrtAllRatio,
        LinICML03,
        kNN,
        Precision,
        Recall,
        FMeasure;

    }
}

