/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic;

import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatures;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArabicMorphoFeatureSpecification
extends MorphoFeatureSpecification {
    private static final long serialVersionUID = 4448045447200922076L;
    private static final String[] defVals = new String[]{"I", "D"};
    private static final String[] caseVals = new String[]{"NOM", "ACC", "GEN"};
    private static final String[] genVals = new String[]{"M", "F"};
    private static final String[] numVals = new String[]{"SG", "DU", "PL"};
    private static final String[] perVals = new String[]{"1", "2", "3"};
    private static final String[] possVals = new String[]{"POSS"};
    private static final String[] voiceVals = new String[]{"ACT", "PASS"};
    private static final String[] moodVals = new String[]{"I", "S", "J"};
    private static final String[] tenseVals = new String[]{"PAST", "PRES", "IMP"};
    private static final Pattern pFeatureTuple = Pattern.compile("(\\d\\p{Upper}\\p{Upper}?)");
    private static final Pattern pDemPronounFeatures = Pattern.compile("DEM_PRON(.+)");
    private static final Pattern pVerbMood = Pattern.compile("MOOD|SUBJ");
    private static final Pattern pMood = Pattern.compile("_MOOD:([ISJ])");
    private static final Pattern pVerbTenseMarker = Pattern.compile("IV|PV|CV");
    private static final Pattern pNounNoMorph = Pattern.compile("PROP|QUANT");

    @Override
    public List<String> getValues(MorphoFeatureSpecification.MorphoFeatureType feat) {
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.DEF) {
            return Arrays.asList(defVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.CASE) {
            throw new RuntimeException(this.getClass().getName() + ": Case is presently unsupported!");
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.GEN) {
            return Arrays.asList(genVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.NUM) {
            return Arrays.asList(numVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.PER) {
            return Arrays.asList(perVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.POSS) {
            return Arrays.asList(possVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.VOICE) {
            return Arrays.asList(voiceVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.MOOD) {
            return Arrays.asList(moodVals);
        }
        if (feat == MorphoFeatureSpecification.MorphoFeatureType.TENSE) {
            return Arrays.asList(tenseVals);
        }
        throw new IllegalArgumentException("Arabic does not support feature type: " + feat.toString());
    }

    @Override
    public MorphoFeatures strToFeatures(String spec) {
        ArabicMorphoFeatures features = new ArabicMorphoFeatures();
        if (spec == null || spec.equals("")) {
            return features;
        }
        if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.POSS) && spec.contains("POSS")) {
            features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.POSS, possVals[0]);
        }
        if (spec.contains("NSUFF") || spec.contains("NOUN") || spec.contains("ADJ")) {
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.NGEN)) {
                if (spec.contains("FEM")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NGEN, genVals[1]);
                } else if (spec.contains("MASC") || !pNounNoMorph.matcher(spec).find()) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NGEN, genVals[0]);
                }
            }
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.NNUM)) {
                if (spec.contains("DU")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NNUM, numVals[1]);
                } else if (spec.contains("PL")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NNUM, numVals[2]);
                } else if (!pNounNoMorph.matcher(spec).find()) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NNUM, numVals[0]);
                }
            }
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.DEF)) {
                if (spec.contains("DET")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.DEF, defVals[1]);
                } else if (!pNounNoMorph.matcher(spec).find()) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.DEF, defVals[0]);
                }
            }
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.PROP) && spec.contains("PROP")) {
                features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.PROP, "");
            }
        } else if (spec.contains("PRON") || spec.contains("VSUFF_DO") && !pVerbMood.matcher(spec).find()) {
            if (spec.contains("DEM_PRON")) {
                features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.DEF, defVals[0]);
                Matcher m = pDemPronounFeatures.matcher(spec);
                if (m.find()) {
                    spec = m.group(1);
                    this.processInflectionalFeaturesHelper(features, spec);
                }
            } else {
                this.processInflectionalFeatures(features, spec);
            }
        } else if (pVerbTenseMarker.matcher(spec).find()) {
            Matcher moodMatcher;
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.TENSE)) {
                if (spec.contains("PV")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.TENSE, tenseVals[0]);
                } else if (spec.contains("IV")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.TENSE, tenseVals[1]);
                } else if (spec.contains("CV")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.TENSE, tenseVals[2]);
                }
            }
            this.processInflectionalFeatures(features, spec);
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.MOOD) && (moodMatcher = pMood.matcher(spec)).find()) {
                String moodStr = moodMatcher.group(1);
                if (moodStr.equals("I")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.MOOD, moodVals[0]);
                } else if (moodStr.equals("S")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.MOOD, moodVals[1]);
                } else if (moodStr.equals("J")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.MOOD, moodVals[2]);
                }
            }
            if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.VOICE)) {
                if (spec.contains("PASS")) {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.VOICE, voiceVals[1]);
                } else {
                    features.addFeature(MorphoFeatureSpecification.MorphoFeatureType.VOICE, voiceVals[0]);
                }
            }
        }
        return features;
    }

    private void processInflectionalFeatures(MorphoFeatures feats, String spec) {
        Matcher m = pFeatureTuple.matcher(spec);
        if (m.find()) {
            spec = m.group(1);
            this.processInflectionalFeaturesHelper(feats, spec);
        }
    }

    private void processInflectionalFeaturesHelper(MorphoFeatures feats, String spec) {
        if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.GEN)) {
            if (spec.contains("M")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.GEN, genVals[0]);
            } else if (spec.contains("F")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.GEN, genVals[1]);
            }
        }
        if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.NUM)) {
            if (spec.endsWith("S")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[0]);
            } else if (spec.endsWith("D")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[1]);
            } else if (spec.endsWith("P")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.NUM, numVals[2]);
            }
        }
        if (this.isActive(MorphoFeatureSpecification.MorphoFeatureType.PER)) {
            if (spec.contains("1")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.PER, perVals[0]);
            } else if (spec.contains("2")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.PER, perVals[1]);
            } else if (spec.contains("3")) {
                feats.addFeature(MorphoFeatureSpecification.MorphoFeatureType.PER, perVals[2]);
            }
        }
    }

    public static void main(String[] args) {
        String[] feats;
        if (args.length != 2) {
            System.err.printf("Usage: java %s filename feats%n", ArabicMorphoFeatureSpecification.class.getName());
            System.exit(-1);
        }
        ArabicMorphoFeatureSpecification fSpec = new ArabicMorphoFeatureSpecification();
        for (String feat : feats = args[1].split(",")) {
            MorphoFeatureSpecification.MorphoFeatureType fType = MorphoFeatureSpecification.MorphoFeatureType.valueOf(feat);
            fSpec.activate(fType);
        }
        File fName = new File(args[0]);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fName)));
            int nLine = 0;
            while ((line = br.readLine()) != null) {
                MorphoFeatures mFeats = ((MorphoFeatureSpecification)fSpec).strToFeatures(line.trim());
                System.out.printf("%s\t%s%n", line.trim(), mFeats.toString());
                ++nLine;
            }
            br.close();
            System.out.printf("%nRead %d lines%n", nLine);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ArabicMorphoFeatures
    extends MorphoFeatures {
        private static final long serialVersionUID = -4611776415583633186L;

        @Override
        public MorphoFeatures fromTagString(String str) {
            String[] feats = str.split("\\-");
            ArabicMorphoFeatures mFeats = new ArabicMorphoFeatures();
            for (int i = 1; i < feats.length; ++i) {
                String[] keyValue = feats[i].split(":");
                if (keyValue.length != 2) continue;
                MorphoFeatureSpecification.MorphoFeatureType fName = MorphoFeatureSpecification.MorphoFeatureType.valueOf(keyValue[0].trim());
                mFeats.addFeature(fName, keyValue[1].trim());
            }
            return mFeats;
        }

        @Override
        public String getTag(String basePartOfSpeech) {
            StringBuilder sb = new StringBuilder(basePartOfSpeech);
            for (MorphoFeatureSpecification.MorphoFeatureType feat : MorphoFeatureSpecification.MorphoFeatureType.values()) {
                if (!this.hasFeature(feat)) continue;
                sb.append(String.format("-%s:%s", new Object[]{feat, this.fSpec.get((Object)feat)}));
            }
            return sb.toString();
        }
    }
}

