/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Maps;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static boolean hasProperty(Properties props, String key) {
        String value = props.getProperty(key);
        if (value == null) {
            return false;
        }
        return !(value = value.toLowerCase()).equals("false") && !value.equals("no") && !value.equals("off");
    }

    public static Properties asProperties(String ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("Need an even number of arguments but there were " + args.length);
        }
        Properties properties = new Properties();
        for (int i = 0; i < args.length; i += 2) {
            properties.setProperty(args[i], args[i + 1]);
        }
        return properties;
    }

    public static String asString(Properties props) {
        try {
            StringWriter sw = new StringWriter();
            props.store(sw, null);
            return sw.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties fromString(String str) {
        try {
            StringReader sr = new StringReader(str);
            Properties props = new Properties();
            props.load(sr);
            return props;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void printProperties(String message, Properties properties, PrintStream stream) {
        if (message != null) {
            stream.println(message);
        }
        if (properties.isEmpty()) {
            stream.println("  [empty]");
        } else {
            List<Map.Entry<String, String>> entries = PropertiesUtils.getSortedEntries(properties);
            for (Map.Entry<String, String> entry : entries) {
                if ("".equals(entry.getKey())) continue;
                stream.format("  %-30s = %s%n", entry.getKey(), entry.getValue());
            }
        }
        stream.println();
    }

    public static void printProperties(String message, Properties properties) {
        PropertiesUtils.printProperties(message, properties, System.out);
    }

    public static Map<String, String> asMap(Properties properties) {
        Map<String, String> map = Generics.newHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    public static List<Map.Entry<String, String>> getSortedEntries(Properties properties) {
        return Maps.sortedEntries(PropertiesUtils.asMap(properties));
    }

    public static void checkProperties(Properties properties, Properties defaults) {
        Set<String> names = Generics.newHashSet();
        for (String name : properties.stringPropertyNames()) {
            names.add(name);
        }
        for (String defaultName : defaults.stringPropertyNames()) {
            names.remove(defaultName);
        }
        if (!names.isEmpty()) {
            if (names.size() == 1) {
                throw new IllegalArgumentException("Unknown property: " + (String)names.iterator().next());
            }
            throw new IllegalArgumentException("Unknown properties: " + names);
        }
    }

    public static Properties extractPrefixedProperties(Properties properties, String prefix) {
        return PropertiesUtils.extractPrefixedProperties(properties, prefix, false);
    }

    public static Properties extractPrefixedProperties(Properties properties, String prefix, boolean keepPrefix) {
        Properties ret = new Properties();
        for (String keyStr : properties.stringPropertyNames()) {
            if (!keyStr.startsWith(prefix)) continue;
            if (keepPrefix) {
                ret.setProperty(keyStr, properties.getProperty(keyStr));
                continue;
            }
            String newStr = keyStr.substring(prefix.length());
            ret.setProperty(newStr, properties.getProperty(keyStr));
        }
        return ret;
    }

    public static Properties extractSelectedProperties(Properties properties, Set<String> keptProperties) {
        Properties ret = new Properties();
        for (String keyStr : properties.stringPropertyNames()) {
            if (!keptProperties.contains(keyStr)) continue;
            ret.setProperty(keyStr, properties.getProperty(keyStr));
        }
        return ret;
    }

    public static <E> E get(Properties props, String key, E defaultValue, Type type) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return MetaClass.cast(value, type);
    }

    public static String getString(Properties props, String key, String defaultValue) {
        String value = props.getProperty(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static int getInt(Properties props, String key) {
        return PropertiesUtils.getInt(props, key, 0);
    }

    public static int getInt(Properties props, String key, int defaultValue) {
        String value = props.getProperty(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static long getLong(Properties props, String key, long defaultValue) {
        String value = props.getProperty(key);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public static double getDouble(Properties props, String key) {
        return PropertiesUtils.getDouble(props, key, 0.0);
    }

    public static double getDouble(Properties props, String key, double defaultValue) {
        String value = props.getProperty(key);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public static boolean getBool(Properties props, String key) {
        return PropertiesUtils.getBool(props, key, false);
    }

    public static boolean getBool(Properties props, String key, boolean defaultValue) {
        String value = props.getProperty(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static int[] getIntArray(Properties props, String key) {
        Integer[] result = (Integer[])MetaClass.cast(props.getProperty(key), Integer[].class);
        return ArrayUtils.toPrimitive(result);
    }

    public static double[] getDoubleArray(Properties props, String key) {
        Double[] result = (Double[])MetaClass.cast(props.getProperty(key), Double[].class);
        return ArrayUtils.toPrimitive(result);
    }

    public static String[] getStringArray(Properties props, String key) {
        String[] results = (String[])MetaClass.cast(props.getProperty(key), String[].class);
        if (results == null) {
            results = StringUtils.EMPTY_STRING_ARRAY;
        }
        return results;
    }

    public static String[] getStringArray(Properties props, String key, String[] defaults) {
        String[] results = (String[])MetaClass.cast(props.getProperty(key), String[].class);
        if (results == null) {
            results = defaults;
        }
        return results;
    }

    public static Properties overWriteProperties(Properties bp, Properties ovp) {
        for (String propertyName : ovp.stringPropertyNames()) {
            bp.setProperty(propertyName, ovp.getProperty(propertyName));
        }
        return bp;
    }

    public static String getSignature(String name, Properties properties, Property[] supportedProperties) {
        String prefix = name != null && !name.isEmpty() ? name + '.' : "";
        StringBuilder sb = new StringBuilder();
        for (Property p : supportedProperties) {
            String pname = prefix + p.name();
            String pvalue = properties.getProperty(pname, p.defaultValue());
            sb.append(pname).append(':').append(pvalue);
        }
        return sb.toString();
    }

    public static String getSignature(String name, Properties properties) {
        String prefix = name != null && !name.isEmpty() ? name + '.' : "";
        StringBuilder sb = new StringBuilder();
        for (String str : properties.stringPropertyNames()) {
            if (!str.startsWith(prefix)) continue;
            String pname = str;
            String pvalue = properties.getProperty(pname);
            sb.append(pname).append(':').append(pvalue);
        }
        return sb.toString();
    }

    public static class Property {
        private final String name;
        private final String defaultValue;
        private final String description;

        public Property(String name, String defaultValue, String description) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public String name() {
            return this.name;
        }

        public String defaultValue() {
            return this.defaultValue;
        }
    }
}

