/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Comparators;
import edu.stanford.nlp.util.Interval;
import java.util.Comparator;

public interface HasInterval<E extends Comparable<E>> {
    public static final Comparator<HasInterval<Integer>> LENGTH_GT_COMPARATOR = (e1, e2) -> {
        int len2;
        int len1 = (Integer)e1.getInterval().getEnd() - (Integer)e1.getInterval().getBegin();
        if (len1 == (len2 = (Integer)e2.getInterval().getEnd() - (Integer)e2.getInterval().getBegin())) {
            return 0;
        }
        return len1 > len2 ? -1 : 1;
    };
    public static final Comparator<HasInterval<Integer>> LENGTH_LT_COMPARATOR = (e1, e2) -> {
        int len2;
        int len1 = (Integer)e1.getInterval().getEnd() - (Integer)e1.getInterval().getBegin();
        if (len1 == (len2 = (Integer)e2.getInterval().getEnd() - (Integer)e2.getInterval().getBegin())) {
            return 0;
        }
        return len1 < len2 ? -1 : 1;
    };
    public static final Comparator<HasInterval> ENDPOINTS_COMPARATOR = (e1, e2) -> e1.getInterval().compareTo(e2.getInterval());
    public static final Comparator<HasInterval> NESTED_FIRST_ENDPOINTS_COMPARATOR = (e1, e2) -> {
        Interval.RelType rel = e1.getInterval().getRelation(e2.getInterval());
        if (rel.equals((Object)Interval.RelType.CONTAIN)) {
            return 1;
        }
        if (rel.equals((Object)Interval.RelType.INSIDE)) {
            return -1;
        }
        return e1.getInterval().compareTo(e2.getInterval());
    };
    public static final Comparator<HasInterval> CONTAINS_FIRST_ENDPOINTS_COMPARATOR = (e1, e2) -> {
        Interval.RelType rel = e1.getInterval().getRelation(e2.getInterval());
        if (rel.equals((Object)Interval.RelType.CONTAIN)) {
            return -1;
        }
        if (rel.equals((Object)Interval.RelType.INSIDE)) {
            return 1;
        }
        return e1.getInterval().compareTo(e2.getInterval());
    };
    public static final Comparator<HasInterval<Integer>> LENGTH_ENDPOINTS_COMPARATOR = Comparators.chain(LENGTH_GT_COMPARATOR, ENDPOINTS_COMPARATOR);

    public Interval<E> getInterval();
}

