/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;

class ExtractorWordShapeClassifier
extends Extractor {
    private final int wordShaper;
    private final String name;
    private static final long serialVersionUID = 101L;

    ExtractorWordShapeClassifier(int position, String wsc) {
        super(position, false);
        this.wordShaper = WordShapeClassifier.lookupShaper(wsc);
        this.name = "ExtractorWordShapeClassifier(" + position + ',' + wsc + ')';
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String s = super.extract(h, pH);
        String shape = WordShapeClassifier.wordShape(s, this.wordShaper);
        return shape;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean isLocal() {
        return this.position == 0;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

