/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.hcoref.CorefCoreAnnotations;
import edu.stanford.nlp.hcoref.data.CorefChain;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.OperatorSpec;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorFactories;
import edu.stanford.nlp.pipeline.AnnotatorFactory;
import edu.stanford.nlp.pipeline.AnnotatorImplementations;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.XMLOutputter;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntTuple;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class Document {
    protected static final Properties EMPTY_PROPS = new Properties(){
        {
            this.setProperty("annotators", "");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "en");
        }
    };
    private static final AnnotatorImplementations backend = new AnnotatorImplementations();
    private static final Annotator defaultTokenize = AnnotatorFactories.tokenize(EMPTY_PROPS, backend).create();
    private static final Annotator defaultSSplit = AnnotatorFactories.sentenceSplit(EMPTY_PROPS, backend).create();
    private static Supplier<Annotator> defaultPOS = new Supplier<Annotator>(){
        Annotator impl = null;

        @Override
        public synchronized Annotator get() {
            if (this.impl == null) {
                this.impl = AnnotatorFactories.posTag(EMPTY_PROPS, backend).create();
            }
            return this.impl;
        }
    };
    private static final Annotator defaultLemma = AnnotatorFactories.lemma(EMPTY_PROPS, backend).create();
    private static Supplier<Annotator> defaultNER = new Supplier<Annotator>(){
        Annotator impl = null;

        @Override
        public synchronized Annotator get() {
            if (this.impl == null) {
                this.impl = AnnotatorFactories.nerTag(EMPTY_PROPS, backend).create();
            }
            return this.impl;
        }
    };
    private static Supplier<Annotator> defaultRegexner = new Supplier<Annotator>(){
        Annotator impl = null;

        @Override
        public synchronized Annotator get() {
            if (this.impl == null) {
                this.impl = AnnotatorFactories.regexNER(EMPTY_PROPS, backend).create();
            }
            return this.impl;
        }
    };
    private static Supplier<Annotator> defaultParse = new Supplier<Annotator>(){
        Annotator impl = null;

        @Override
        public synchronized Annotator get() {
            if (this.impl == null) {
                this.impl = AnnotatorFactories.parse(EMPTY_PROPS, backend).create();
            }
            return this.impl;
        }
    };
    private static Supplier<Annotator> defaultDepparse = new Supplier<Annotator>(){
        Annotator impl = null;

        @Override
        public synchronized Annotator get() {
            if (this.impl == null) {
                this.impl = AnnotatorFactories.dependencies(EMPTY_PROPS, backend).create();
            }
            return this.impl;
        }
    };
    private static Supplier<Annotator> defaultNatlog = new Supplier<Annotator>(){
        Annotator impl = null;

        @Override
        public synchronized Annotator get() {
            if (this.impl == null) {
                this.impl = AnnotatorFactories.natlog(EMPTY_PROPS, backend).create();
            }
            return this.impl;
        }
    };
    private static Supplier<Annotator> defaultOpenie = new Supplier<Annotator>(){
        Annotator impl = null;

        @Override
        public synchronized Annotator get() {
            if (this.impl == null) {
                this.impl = AnnotatorFactories.openie(EMPTY_PROPS, backend).create();
            }
            return this.impl;
        }
    };
    private static Supplier<Annotator> defaultMention = new Supplier<Annotator>(){
        Annotator impl = null;

        @Override
        public synchronized Annotator get() {
            if (this.impl == null) {
                this.impl = AnnotatorFactories.mention(EMPTY_PROPS, backend).create();
            }
            return this.impl;
        }
    };
    private static Supplier<Annotator> defaultCoref = new Supplier<Annotator>(){
        Annotator impl = null;

        @Override
        public synchronized Annotator get() {
            if (this.impl == null) {
                this.impl = AnnotatorFactories.coref(EMPTY_PROPS, backend).create();
            }
            return this.impl;
        }
    };
    private static final LinkedHashMap<String, Annotator> customAnnotators = new LinkedHashMap();
    private static final IdentityHashMap<Document, Annotation> annotationPool = new IdentityHashMap();
    private static final LinkedList<Document> annotationPoolKeys = new LinkedList();
    private static final int MAX_ANNOTATION_POOL_SIZE = 64;
    private final CoreNLPProtos.Document.Builder impl;
    private List<Sentence> sentences = null;
    protected final ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer(false);
    private boolean haveRunOpenie = false;

    private static synchronized Annotator getOrCreate(AnnotatorFactory factory) {
        Annotator rtn = customAnnotators.get(factory.signature());
        if (rtn == null) {
            rtn = factory.create();
            customAnnotators.put(factory.signature(), factory.create());
            while (customAnnotators.size() > 10) {
                customAnnotators.keySet().iterator().remove();
            }
        }
        return rtn;
    }

    public Document(String text) {
        this.impl = CoreNLPProtos.Document.newBuilder().setText(text);
    }

    public Document(Annotation ann) {
        this.impl = new ProtobufAnnotationSerializer(false).toProtoBuilder(ann);
        List sentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
        this.sentences = new ArrayList<Sentence>(sentences.size());
        for (CoreMap sentence : sentences) {
            this.sentences.add(new Sentence(this, this.serializer.toProtoBuilder(sentence), (String)sentence.get(CoreAnnotations.TextAnnotation.class)));
        }
    }

    public Document(CoreNLPProtos.Document proto) {
        this.impl = proto.toBuilder();
        if (proto.getSentenceCount() > 0) {
            this.sentences = new ArrayList<Sentence>(proto.getSentenceCount());
            for (CoreNLPProtos.Sentence sentence : proto.getSentenceList()) {
                this.sentences.add(new Sentence(this, sentence.toBuilder()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreNLPProtos.Document serialize() {
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            this.impl.clearSentence();
            for (Sentence sent : this.sentences()) {
                this.impl.addSentence(sent.serialize());
            }
            return this.impl.build();
        }
    }

    public void serialize(OutputStream out2) throws IOException {
        this.serialize().writeDelimitedTo(out2);
        out2.flush();
    }

    public static Document deserialize(InputStream in) throws IOException {
        return new Document(CoreNLPProtos.Document.parseDelimitedFrom(in));
    }

    @SafeVarargs
    public final String json(Function<Sentence, Object> ... functions) {
        for (Function<Sentence, Object> f : functions) {
            f.apply(this.sentence(0));
        }
        try {
            return new JSONOutputter().print(this.asAnnotation());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @SafeVarargs
    public final String jsonMinified(Function<Sentence, Object> ... functions) {
        for (Function<Sentence, Object> f : functions) {
            f.apply(this.sentence(0));
        }
        try {
            AnnotationOutputter.Options options = new AnnotationOutputter.Options();
            options.pretty = false;
            return new JSONOutputter().print(this.asAnnotation(), options);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @SafeVarargs
    public final String xml(Function<Sentence, Object> ... functions) {
        for (Function<Sentence, Object> f : functions) {
            f.apply(this.sentence(0));
        }
        try {
            return new XMLOutputter().print(this.asAnnotation());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @SafeVarargs
    public final String xmlMinified(Function<Sentence, Object> ... functions) {
        for (Function<Sentence, Object> f : functions) {
            f.apply(this.sentence(0));
        }
        try {
            AnnotationOutputter.Options options = new AnnotationOutputter.Options();
            options.pretty = false;
            return new XMLOutputter().print(this.asAnnotation(), options);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Sentence> sentences(Properties props) {
        if (this.sentences == null) {
            Annotator tokenizer = props == EMPTY_PROPS ? defaultTokenize : AnnotatorFactories.tokenize(props, backend).create();
            Annotator ssplit = props == EMPTY_PROPS ? defaultSSplit : AnnotatorFactories.sentenceSplit(props, backend).create();
            Annotation ann = new Annotation(this.impl.getText());
            tokenizer.annotate(ann);
            ssplit.annotate(ann);
            if (ann.containsKey(CoreAnnotations.DocIDAnnotation.class)) {
                this.impl.setDocID((String)ann.get(CoreAnnotations.DocIDAnnotation.class));
            }
            List sentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
            this.sentences = new ArrayList<Sentence>(sentences.size());
            for (CoreMap sentence : sentences) {
                Sentence sent = new Sentence(this, this.serializer.toProtoBuilder(sentence), (String)sentence.get(CoreAnnotations.TextAnnotation.class));
                this.sentences.add(sent);
                this.impl.addSentence(sent.serialize());
            }
        }
        Cloneable cloneable = annotationPool;
        synchronized (cloneable) {
            annotationPool.remove(this);
        }
        cloneable = annotationPoolKeys;
        synchronized (cloneable) {
            annotationPoolKeys.remove(this);
        }
        return this.sentences;
    }

    public List<Sentence> sentences() {
        return this.sentences(EMPTY_PROPS);
    }

    public Sentence sentence(int sentenceIndex, Properties props) {
        return this.sentences(props).get(sentenceIndex);
    }

    public Sentence sentence(int sentenceIndex) {
        return this.sentences().get(sentenceIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String text() {
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            return this.impl.getText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, CorefChain> coref(Properties props) {
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            if (this.impl.getCorefChainCount() == 0) {
                this.runLemma(props).runNER(props).runParse(props);
                Annotator mention = props == EMPTY_PROPS ? defaultMention.get() : AnnotatorFactories.mention(props, backend).create();
                Annotator coref = props == EMPTY_PROPS ? defaultCoref.get() : AnnotatorFactories.coref(props, backend).create();
                Annotation ann = this.asAnnotation();
                mention.annotate(ann);
                coref.annotate(ann);
                ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
                synchronized (protobufAnnotationSerializer) {
                    for (CorefChain chain : ((Map)ann.get(CorefCoreAnnotations.CorefChainAnnotation.class)).values()) {
                        this.impl.addCorefChain(this.serializer.toProto(chain));
                    }
                }
            }
            Map<Integer, CorefChain> corefs = Generics.newHashMap();
            for (CoreNLPProtos.CorefChain chain : this.impl.getCorefChainList()) {
                corefs.put(chain.getChainID(), this.fromProto(chain));
            }
            return corefs;
        }
    }

    public Map<Integer, CorefChain> coref() {
        return this.coref(EMPTY_PROPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> docid() {
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            if (this.impl.hasDocID()) {
                return Optional.of(this.impl.getDocID());
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document setDocid(String docid) {
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            this.impl.setDocID(docid);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceSentences(List<Sentence> sentences) {
        this.sentences = sentences;
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            this.impl.clearSentence();
            for (Sentence sent : sentences) {
                this.impl.addSentence(sent.serialize());
            }
        }
    }

    protected Document runPOS(Properties props) {
        if (this.sentences != null && this.sentences.size() > 0 && this.sentences.get(0).rawToken(0).hasPos()) {
            return this;
        }
        this.sentences();
        Annotator pos = props == EMPTY_PROPS ? defaultPOS.get() : Document.getOrCreate(AnnotatorFactories.posTag(props, backend));
        Annotation ann = this.asAnnotation();
        pos.annotate(ann);
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setPos((String)pair.second), CoreLabel::tag);
        }
        return this;
    }

    protected Document runLemma(Properties props) {
        if (this.sentences != null && this.sentences.size() > 0 && this.sentences.get(0).rawToken(0).hasLemma()) {
            return this;
        }
        this.runPOS(props);
        Annotator lemma = props == EMPTY_PROPS ? defaultLemma : Document.getOrCreate(AnnotatorFactories.lemma(props, backend));
        Annotation ann = this.asAnnotation();
        lemma.annotate(ann);
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setLemma((String)pair.second), CoreLabel::lemma);
        }
        return this;
    }

    protected Document runNER(Properties props) {
        if (this.sentences != null && this.sentences.size() > 0 && this.sentences.get(0).rawToken(0).hasNer()) {
            return this;
        }
        this.runPOS(props);
        Annotator ner = props == EMPTY_PROPS ? defaultNER.get() : Document.getOrCreate(AnnotatorFactories.nerTag(props, backend));
        Annotation ann = this.asAnnotation();
        ner.annotate(ann);
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setNer((String)pair.second), CoreLabel::ner);
        }
        return this;
    }

    protected Document runRegexner(Properties props) {
        this.runNER(props);
        Annotator ner = props == EMPTY_PROPS ? defaultRegexner.get() : Document.getOrCreate(AnnotatorFactories.regexNER(props, backend));
        Annotation ann = this.asAnnotation();
        ner.annotate(ann);
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setNer((String)pair.second), CoreLabel::ner);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document runParse(Properties props) {
        Annotator parse;
        if (this.sentences != null && this.sentences.size() > 0 && this.sentences.get(0).rawSentence().hasParseTree()) {
            return this;
        }
        Annotator annotator = parse = props == EMPTY_PROPS ? defaultParse.get() : Document.getOrCreate(AnnotatorFactories.parse(props, backend));
        if (parse.requires().contains(Annotator.POS_REQUIREMENT)) {
            this.runPOS(props);
        } else {
            this.sentences();
        }
        Annotation ann = this.asAnnotation();
        parse.annotate(ann);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
        synchronized (protobufAnnotationSerializer) {
            for (int i = 0; i < this.sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
                Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                this.sentences.get(i).updateParse(this.serializer.toProto(tree));
                this.sentences.get(i).updateDependencies(ProtobufAnnotationSerializer.toProto((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)), ProtobufAnnotationSerializer.toProto((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class)), ProtobufAnnotationSerializer.toProto((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class)));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document runDepparse(Properties props) {
        if (this.sentences != null && this.sentences.size() > 0 && this.sentences.get(0).rawSentence().hasBasicDependencies()) {
            return this;
        }
        this.runPOS(props);
        Annotator depparse = props == EMPTY_PROPS ? defaultDepparse.get() : Document.getOrCreate(AnnotatorFactories.dependencies(props, backend));
        Annotation ann = this.asAnnotation();
        depparse.annotate(ann);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
        synchronized (protobufAnnotationSerializer) {
            for (int i = 0; i < this.sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
                this.sentences.get(i).updateDependencies(ProtobufAnnotationSerializer.toProto((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)), ProtobufAnnotationSerializer.toProto((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class)), ProtobufAnnotationSerializer.toProto((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class)));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document runNatlog(Properties props) {
        if (this.sentences != null && this.sentences.size() > 0 && this.sentences.get(0).rawToken(0).hasPolarity()) {
            return this;
        }
        this.runLemma(props);
        this.runDepparse(props);
        Annotator natlog = props == EMPTY_PROPS ? defaultNatlog.get() : Document.getOrCreate(AnnotatorFactories.natlog(props, backend));
        Annotation ann = this.asAnnotation();
        natlog.annotate(ann);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
        synchronized (protobufAnnotationSerializer) {
            for (int i = 0; i < this.sentences.size(); ++i) {
                this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setPolarity(ProtobufAnnotationSerializer.toProto((Polarity)pair.second)), x -> (Polarity)x.get(NaturalLogicAnnotations.PolarityAnnotation.class));
                this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setOperator(ProtobufAnnotationSerializer.toProto((OperatorSpec)pair.second)), x -> (OperatorSpec)x.get(NaturalLogicAnnotations.OperatorAnnotation.class));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document runOpenie(Properties props) {
        if (this.haveRunOpenie) {
            return this;
        }
        this.runNatlog(props);
        Annotator openie = props == EMPTY_PROPS ? defaultOpenie.get() : Document.getOrCreate(AnnotatorFactories.openie(props, backend));
        Annotation ann = this.asAnnotation();
        openie.annotate(ann);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
        synchronized (protobufAnnotationSerializer) {
            for (int i = 0; i < this.sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
                Collection triples = (Collection)sentence.get(NaturalLogicAnnotations.RelationTriplesAnnotation.class);
                this.sentences.get(i).updateTriples(triples.stream().map(ProtobufAnnotationSerializer::toProto));
            }
        }
        this.haveRunOpenie = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation asAnnotation() {
        IdentityHashMap<Document, Annotation> identityHashMap = annotationPool;
        synchronized (identityHashMap) {
            Annotation candidate = annotationPool.get(this);
            if (candidate == null) {
                Object object = this.serializer;
                synchronized (object) {
                    candidate = this.serializer.fromProto(this.serialize());
                }
                annotationPool.put(this, candidate);
                object = annotationPoolKeys;
                synchronized (object) {
                    annotationPoolKeys.addLast(this);
                    while (annotationPoolKeys.size() > 64) {
                        annotationPool.remove(annotationPoolKeys.removeFirst());
                    }
                }
            }
            return candidate;
        }
    }

    private CorefChain fromProto(CoreNLPProtos.CorefChain proto) {
        int cid = proto.getChainID();
        HashMap<IntPair, Set<CorefChain.CorefMention>> mentions = new HashMap<IntPair, Set<CorefChain.CorefMention>>();
        CorefChain.CorefMention representative = null;
        for (int i = 0; i < proto.getMentionCount(); ++i) {
            CoreNLPProtos.CorefChain.CorefMention mentionProto = proto.getMention(i);
            StringBuilder mentionSpan = new StringBuilder();
            Sentence sentence = this.sentence(mentionProto.getSentenceIndex());
            for (int k = mentionProto.getBeginIndex(); k < mentionProto.getEndIndex(); ++k) {
                mentionSpan.append(" ").append(sentence.word(k));
            }
            CorefChain.CorefMention mention = new CorefChain.CorefMention(Dictionaries.MentionType.valueOf(mentionProto.getMentionType()), Dictionaries.Number.valueOf(mentionProto.getNumber()), Dictionaries.Gender.valueOf(mentionProto.getGender()), Dictionaries.Animacy.valueOf(mentionProto.getAnimacy()), mentionProto.getBeginIndex() + 1, mentionProto.getEndIndex() + 1, mentionProto.getHeadIndex() + 1, cid, mentionProto.getMentionID(), mentionProto.getSentenceIndex() + 1, new IntTuple(new int[]{mentionProto.getSentenceIndex() + 1, mentionProto.getPosition()}), mentionSpan.substring(mentionSpan.length() > 0 ? 1 : 0));
            IntPair key = new IntPair(mentionProto.getSentenceIndex() - 1, mentionProto.getHeadIndex() - 1);
            if (!mentions.containsKey(key)) {
                mentions.put(key, new HashSet());
            }
            ((Set)mentions.get(key)).add(mention);
            if (!proto.hasRepresentative() || i != proto.getRepresentative()) continue;
            representative = mention;
        }
        return new CorefChain(cid, mentions, representative);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document document = (Document)o;
        if (this.impl.hasText() && !this.impl.getText().equals(document.impl.getText())) {
            return false;
        }
        return this.impl.build().equals(document.impl.build()) && this.sentences.equals(document.sentences);
    }

    public int hashCode() {
        if (this.impl.hasText()) {
            return this.impl.getText().hashCode();
        }
        return this.impl.build().hashCode();
    }

    public String toString() {
        return this.impl.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        Cloneable cloneable = annotationPool;
        synchronized (cloneable) {
            annotationPool.remove(this);
        }
        cloneable = annotationPoolKeys;
        synchronized (cloneable) {
            annotationPoolKeys.remove(this);
        }
    }
}

