/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentModel;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class SentimentUtils {
    static final Predicate<Tree> UNKNOWN_ROOT_FILTER = tree -> {
        int gold = RNNCoreAnnotations.getGoldClass(tree);
        return gold != -1;
    };

    private SentimentUtils() {
    }

    public static void attachLabels(Tree tree, Class<? extends CoreAnnotation<Integer>> annotationClass) {
        if (tree.isLeaf()) {
            return;
        }
        for (Tree child : tree.children()) {
            SentimentUtils.attachLabels(child, annotationClass);
        }
        int numericLabel = Integer.valueOf(tree.label().value());
        Label label = tree.label();
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("CoreLabels required!");
        }
        ((CoreLabel)label).set(annotationClass, numericLabel);
    }

    public static List<Tree> readTreesWithGoldLabels(String path) {
        return SentimentUtils.readTreesWithLabels(path, RNNCoreAnnotations.GoldClass.class);
    }

    public static List<Tree> readTreesWithPredictedLabels(String path) {
        return SentimentUtils.readTreesWithLabels(path, RNNCoreAnnotations.PredictedClass.class);
    }

    public static List<Tree> readTreesWithLabels(String path, Class<? extends CoreAnnotation<Integer>> annotationClass) {
        ArrayList<Tree> trees = Generics.newArrayList();
        MemoryTreebank treebank = new MemoryTreebank("utf-8");
        treebank.loadPath(path, null);
        for (Tree tree : treebank) {
            SentimentUtils.attachLabels(tree, annotationClass);
            trees.add(tree);
        }
        return trees;
    }

    public static List<Tree> filterUnknownRoots(List<Tree> trees) {
        return CollectionUtils.filterAsList(trees, UNKNOWN_ROOT_FILTER);
    }

    public static String sentimentString(SentimentModel model, int sentiment) {
        String[] classNames = model.op.classNames;
        if (sentiment < 0 || sentiment > classNames.length) {
            return "Unknown sentiment label " + sentiment;
        }
        return classNames[sentiment];
    }
}

