/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.fsm.TransducerGraph;
import edu.stanford.nlp.parser.lexparser.BinaryGrammar;
import edu.stanford.nlp.parser.lexparser.BinaryRule;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.UnaryGrammar;
import edu.stanford.nlp.parser.lexparser.UnaryRule;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Distribution;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GrammarCompactor {
    Set<TransducerGraph> compactedGraphs;
    public static final Object RAW_COUNTS = new Object();
    public static final Object NORMALIZED_LOG_PROBABILITIES = new Object();
    public Object outputType = RAW_COUNTS;
    protected Index<String> stateIndex;
    protected Index<String> newStateIndex;
    protected Distribution<String> inputPrior;
    private static final String END = "END";
    private static final String EPSILON = "EPSILON";
    protected boolean verbose = false;
    protected final Options op;

    public GrammarCompactor(Options op) {
        this.op = op;
    }

    protected abstract TransducerGraph doCompaction(TransducerGraph var1, List<List<String>> var2, List<List<String>> var3);

    public Triple<Index<String>, UnaryGrammar, BinaryGrammar> compactGrammar(Pair<UnaryGrammar, BinaryGrammar> grammar, Index<String> originalStateIndex) {
        return this.compactGrammar(grammar, Generics.newHashMap(), Generics.newHashMap(), originalStateIndex);
    }

    public Triple<Index<String>, UnaryGrammar, BinaryGrammar> compactGrammar(Pair<UnaryGrammar, BinaryGrammar> grammar, Map<String, List<List<String>>> allTrainPaths, Map<String, List<List<String>>> allTestPaths, Index<String> originalStateIndex) {
        this.inputPrior = GrammarCompactor.computeInputPrior(allTrainPaths);
        this.stateIndex = originalStateIndex;
        Set<UnaryRule> unaryRules = Generics.newHashSet();
        Set<BinaryRule> binaryRules = Generics.newHashSet();
        Map<String, TransducerGraph> graphs = this.convertGrammarToGraphs(grammar, unaryRules, binaryRules);
        this.compactedGraphs = Generics.newHashSet();
        if (this.verbose) {
            System.out.println("There are " + graphs.size() + " categories to compact.");
        }
        int i = 0;
        Iterator<Map.Entry<String, TransducerGraph>> graphIter = graphs.entrySet().iterator();
        while (graphIter.hasNext()) {
            List<List<String>> testPaths;
            List<List<String>> trainPaths;
            Map.Entry<String, TransducerGraph> entry = graphIter.next();
            String cat = entry.getKey();
            TransducerGraph graph = entry.getValue();
            if (this.verbose) {
                System.out.println("About to compact grammar for " + cat + " with numNodes=" + graph.getNodes().size());
            }
            if ((trainPaths = allTrainPaths.remove(cat)) == null) {
                trainPaths = new ArrayList<List<String>>();
            }
            if ((testPaths = allTestPaths.remove(cat)) == null) {
                testPaths = new ArrayList<List<String>>();
            }
            TransducerGraph compactedGraph = this.doCompaction(graph, trainPaths, testPaths);
            ++i;
            if (this.verbose) {
                System.out.println(i + ". Compacted grammar for " + cat + " from " + graph.getArcs().size() + " arcs to " + compactedGraph.getArcs().size() + " arcs.");
            }
            graphIter.remove();
            this.compactedGraphs.add(compactedGraph);
        }
        Pair<UnaryGrammar, BinaryGrammar> ugbg = this.convertGraphsToGrammar(this.compactedGraphs, unaryRules, binaryRules);
        return new Triple<Index<String>, UnaryGrammar, BinaryGrammar>(this.newStateIndex, ugbg.first(), ugbg.second());
    }

    protected static Distribution<String> computeInputPrior(Map<String, List<List<String>>> allTrainPaths) {
        ClassicCounter<String> result = new ClassicCounter<String>();
        for (List<List<String>> pathList : allTrainPaths.values()) {
            for (List<String> path : pathList) {
                for (String input : path) {
                    result.incrementCount(input);
                }
            }
        }
        return Distribution.laplaceSmoothedDistribution(result, result.size() * 2, 0.5);
    }

    private double smartNegate(double output) {
        if (this.outputType == NORMALIZED_LOG_PROBABILITIES) {
            return -output;
        }
        return output;
    }

    public static boolean writeFile(TransducerGraph graph, String dir, String name) {
        try {
            File baseDir = new File(dir);
            if (baseDir.exists() ? !baseDir.isDirectory() : !baseDir.mkdirs()) {
                return false;
            }
            File file = new File(baseDir, name + ".dot");
            try {
                PrintWriter w = new PrintWriter(new FileWriter(file));
                String dotString = graph.asDOTString();
                w.print(dotString);
                w.flush();
                w.close();
            }
            catch (FileNotFoundException e) {
                System.err.println("Failed to open file in writeToDOTfile: " + file);
                return false;
            }
            catch (IOException e) {
                System.err.println("Failed to open file in writeToDOTfile: " + file);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Map<String, TransducerGraph> convertGrammarToGraphs(Pair<UnaryGrammar, BinaryGrammar> grammar, Set<UnaryRule> unaryRules, Set<BinaryRule> binaryRules) {
        boolean wasAdded;
        int numRules = 0;
        UnaryGrammar ug = (UnaryGrammar)grammar.first;
        BinaryGrammar bg = (BinaryGrammar)grammar.second;
        Map<String, TransducerGraph> graphs = Generics.newHashMap();
        for (Comparable<BinaryRule> rule : bg) {
            ++numRules;
            wasAdded = this.addOneBinaryRule((BinaryRule)rule, graphs);
            if (wasAdded) continue;
            binaryRules.add((BinaryRule)rule);
        }
        for (Comparable<BinaryRule> rule : ug) {
            ++numRules;
            wasAdded = this.addOneUnaryRule((UnaryRule)rule, graphs);
            if (wasAdded) continue;
            unaryRules.add((UnaryRule)rule);
        }
        if (this.verbose) {
            System.out.println("Number of raw rules: " + numRules);
            System.out.println("Number of raw states: " + this.stateIndex.size());
        }
        return graphs;
    }

    protected static TransducerGraph getGraphFromMap(Map<String, TransducerGraph> m, String o) {
        TransducerGraph graph = m.get(o);
        if (graph == null) {
            graph = new TransducerGraph();
            graph.setEndNode(o);
            m.put(o, graph);
        }
        return graph;
    }

    protected static String getTopCategoryOfSyntheticState(String s) {
        if (s.charAt(0) != '@') {
            return null;
        }
        int bar = s.indexOf(124);
        if (bar < 0) {
            throw new RuntimeException("Grammar format error. Expected bar in state name: " + s);
        }
        String topcat = s.substring(1, bar);
        return topcat;
    }

    protected boolean addOneUnaryRule(UnaryRule rule, Map<String, TransducerGraph> graphs) {
        String parentString = this.stateIndex.get(rule.parent);
        String childString = this.stateIndex.get(rule.child);
        if (GrammarCompactor.isSyntheticState(parentString)) {
            String topcat = GrammarCompactor.getTopCategoryOfSyntheticState(parentString);
            TransducerGraph graph = GrammarCompactor.getGraphFromMap(graphs, topcat);
            Double output = new Double(this.smartNegate(rule.score()));
            graph.addArc(graph.getStartNode(), parentString, childString, output);
            return true;
        }
        if (GrammarCompactor.isSyntheticState(childString)) {
            TransducerGraph graph = GrammarCompactor.getGraphFromMap(graphs, parentString);
            Double output = new Double(this.smartNegate(rule.score()));
            graph.addArc(childString, parentString, END, output);
            graph.setEndNode(parentString);
            return true;
        }
        return false;
    }

    protected boolean addOneBinaryRule(BinaryRule rule, Map<String, TransducerGraph> graphs) {
        String input;
        String source;
        String parentString = this.stateIndex.get(rule.parent);
        String leftString = this.stateIndex.get(rule.leftChild);
        String rightString = this.stateIndex.get(rule.rightChild);
        String bracket = null;
        if (this.op.trainOptions.markFinalStates) {
            bracket = parentString.substring(parentString.length() - 1, parentString.length());
        }
        if (GrammarCompactor.isSyntheticState(leftString)) {
            source = leftString;
            input = rightString + (bracket == null ? ">" : bracket);
        } else if (GrammarCompactor.isSyntheticState(rightString)) {
            source = rightString;
            input = leftString + (bracket == null ? "<" : bracket);
        } else {
            return false;
        }
        String target = parentString;
        Double output = new Double(this.smartNegate(rule.score()));
        String topcat = GrammarCompactor.getTopCategoryOfSyntheticState(source);
        if (topcat == null) {
            throw new RuntimeException("can't have null topcat");
        }
        TransducerGraph graph = GrammarCompactor.getGraphFromMap(graphs, topcat);
        graph.addArc(source, target, input, output);
        return true;
    }

    protected static boolean isSyntheticState(String state) {
        return state.charAt(0) == '@';
    }

    /*
     * WARNING - void declaration
     */
    protected Pair<UnaryGrammar, BinaryGrammar> convertGraphsToGrammar(Set<TransducerGraph> graphs, Set<UnaryRule> unaryRules, Set<BinaryRule> binaryRules) {
        void var6_25;
        this.newStateIndex = new HashIndex<String>();
        for (UnaryRule unaryRule : unaryRules) {
            String string = this.stateIndex.get(unaryRule.parent);
            unaryRule.parent = this.newStateIndex.addToIndex(string);
            String child = this.stateIndex.get(unaryRule.child);
            unaryRule.child = this.newStateIndex.addToIndex(child);
        }
        for (BinaryRule binaryRule : binaryRules) {
            String string = this.stateIndex.get(binaryRule.parent);
            binaryRule.parent = this.newStateIndex.addToIndex(string);
            String leftChild = this.stateIndex.get(binaryRule.leftChild);
            binaryRule.leftChild = this.newStateIndex.addToIndex(leftChild);
            String rightChild = this.stateIndex.get(binaryRule.rightChild);
            binaryRule.rightChild = this.newStateIndex.addToIndex(rightChild);
        }
        for (TransducerGraph transducerGraph : graphs) {
            Object object = transducerGraph.getStartNode();
            for (TransducerGraph.Arc arc : transducerGraph.getArcs()) {
                BinaryRule br;
                String source = arc.getSourceNode().toString();
                String string = arc.getTargetNode().toString();
                Object input = arc.getInput();
                String inputString = input.toString();
                double output = (Double)arc.getOutput();
                if (source.equals(object)) {
                    UnaryRule ur = new UnaryRule(this.newStateIndex.addToIndex(string), this.newStateIndex.addToIndex(inputString), this.smartNegate(output));
                    unaryRules.add(ur);
                    continue;
                }
                if (inputString.equals(END) || inputString.equals(EPSILON)) {
                    UnaryRule ur = new UnaryRule(this.newStateIndex.addToIndex(string), this.newStateIndex.addToIndex(source), this.smartNegate(output));
                    unaryRules.add(ur);
                    continue;
                }
                int length = inputString.length();
                char leftOrRight = inputString.charAt(length - 1);
                inputString = inputString.substring(0, length - 1);
                if (leftOrRight == '<' || leftOrRight == '[') {
                    br = new BinaryRule(this.newStateIndex.addToIndex(string), this.newStateIndex.addToIndex(inputString), this.newStateIndex.addToIndex(source), this.smartNegate(output));
                } else if (leftOrRight == '>' || leftOrRight == ']') {
                    br = new BinaryRule(this.newStateIndex.addToIndex(string), this.newStateIndex.addToIndex(source), this.newStateIndex.addToIndex(inputString), this.smartNegate(output));
                } else {
                    throw new RuntimeException("Arc input is in unexpected format: " + arc);
                }
                binaryRules.add(br);
            }
        }
        ClassicCounter<String> symbolCounter = new ClassicCounter<String>();
        if (this.outputType == RAW_COUNTS) {
            for (UnaryRule unaryRule : unaryRules) {
                symbolCounter.incrementCount(this.newStateIndex.get(unaryRule.parent), unaryRule.score);
            }
            for (BinaryRule binaryRule : binaryRules) {
                symbolCounter.incrementCount(this.newStateIndex.get(binaryRule.parent), binaryRule.score);
            }
        }
        int n = this.newStateIndex.size();
        boolean bl = false;
        UnaryGrammar ug = new UnaryGrammar(this.newStateIndex);
        BinaryGrammar bg = new BinaryGrammar(this.newStateIndex);
        for (UnaryRule unaryRule : unaryRules) {
            void var6_24;
            if (this.outputType == RAW_COUNTS) {
                double count = symbolCounter.getCount(this.newStateIndex.get(unaryRule.parent));
                unaryRule.score = (float)Math.log((double)unaryRule.score / count);
            }
            ug.addRule(unaryRule);
            ++var6_24;
        }
        for (BinaryRule binaryRule : binaryRules) {
            if (this.outputType == RAW_COUNTS) {
                double count = symbolCounter.getCount(this.newStateIndex.get(binaryRule.parent));
                binaryRule.score = (float)Math.log(((double)binaryRule.score - this.op.trainOptions.ruleDiscount) / count);
            }
            bg.addRule(binaryRule);
            ++var6_25;
        }
        if (this.verbose) {
            System.out.println("Number of minimized rules: " + (int)var6_25);
            System.out.println("Number of minimized states: " + this.newStateIndex.size());
        }
        ug.purgeRules();
        bg.splitRules();
        return new Pair<UnaryGrammar, BinaryGrammar>(ug, bg);
    }
}

