/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref.md;

import edu.stanford.nlp.hcoref.CorefProperties;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.hcoref.md.CorefMentionFinder;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class RuleBasedCorefMentionFinder
extends CorefMentionFinder {
    public RuleBasedCorefMentionFinder(HeadFinder headFinder, Properties props) {
        this(CorefProperties.allowReparsing(props), headFinder, CorefProperties.getLanguage(props));
    }

    public RuleBasedCorefMentionFinder(boolean allowReparsing, HeadFinder headFinder, Locale lang) {
        this.headFinder = headFinder;
        this.allowReparsing = allowReparsing;
        this.lang = lang;
    }

    public List<List<Mention>> filterPredictedMentions(List<List<Mention>> allGoldMentions, Annotation doc, Dictionaries dict, Properties props) {
        ArrayList<List<Mention>> predictedMentions = new ArrayList<List<Mention>>();
        for (int i = 0; i < allGoldMentions.size(); ++i) {
            CoreMap s = (CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
            List<Mention> goldMentions = allGoldMentions.get(i);
            ArrayList<Mention> mentions = new ArrayList<Mention>();
            predictedMentions.add(mentions);
            mentions.addAll(goldMentions);
            this.findHead(s, mentions);
            Set<IntPair> mentionSpanSet = Generics.newHashSet();
            Set<IntPair> namedEntitySpanSet = Generics.newHashSet();
            for (Mention m : mentions) {
                mentionSpanSet.add(new IntPair(m.startIndex, m.endIndex));
                if (((String)m.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class)).equals("O")) continue;
                namedEntitySpanSet.add(new IntPair(m.startIndex, m.endIndex));
            }
            RuleBasedCorefMentionFinder.setBarePlural(mentions);
        }
        this.removeSpuriousMentions(doc, predictedMentions, dict, CorefProperties.removeNested(props), this.lang);
        return predictedMentions;
    }

    @Override
    public List<List<Mention>> findMentions(Annotation doc, Dictionaries dict, Properties props) {
        ArrayList<List<Mention>> predictedMentions = new ArrayList<List<Mention>>();
        Set<String> neStrings = Generics.newHashSet();
        ArrayList<Set<IntPair>> mentionSpanSetList = Generics.newArrayList();
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap s : sentences) {
            ArrayList<Mention> mentions = new ArrayList<Mention>();
            predictedMentions.add(mentions);
            Set<IntPair> mentionSpanSet = Generics.newHashSet();
            Set<IntPair> namedEntitySpanSet = Generics.newHashSet();
            RuleBasedCorefMentionFinder.extractPremarkedEntityMentions(s, mentions, mentionSpanSet, namedEntitySpanSet);
            RuleBasedCorefMentionFinder.extractNamedEntityMentions(s, mentions, mentionSpanSet, namedEntitySpanSet);
            this.extractNPorPRP(s, mentions, mentionSpanSet, namedEntitySpanSet);
            RuleBasedCorefMentionFinder.extractEnumerations(s, mentions, mentionSpanSet, namedEntitySpanSet);
            RuleBasedCorefMentionFinder.addNamedEntityStrings(s, neStrings, namedEntitySpanSet);
            mentionSpanSetList.add(mentionSpanSet);
        }
        int sz = sentences.size();
        for (int i = 0; i < sz; ++i) {
            this.findHead((CoreMap)sentences.get(i), (List)predictedMentions.get(i));
            RuleBasedCorefMentionFinder.setBarePlural((List)predictedMentions.get(i));
        }
        this.removeSpuriousMentions(doc, predictedMentions, dict, CorefProperties.removeNested(props), this.lang);
        return predictedMentions;
    }

    protected static void setBarePlural(List<Mention> mentions) {
        for (Mention m : mentions) {
            String pos = (String)m.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            if (m.originalSpan.size() != 1 || !pos.equals("NNS")) continue;
            m.generic = true;
        }
    }

    public void extractNPorPRP(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        Tree tree = (Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class);
        tree.indexLeaves();
        SemanticGraph basicDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        SemanticGraph collapsedDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
        TregexPattern tgrepPattern = npOrPrpMentionPattern;
        TregexMatcher matcher = tgrepPattern.matcher(tree);
        while (matcher.find()) {
            IntPair mSpan;
            Tree t = matcher.getMatch();
            List mLeaves = t.getLeaves();
            int beginIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(0)).label()).get(CoreAnnotations.IndexAnnotation.class) - 1;
            int endIdx = (Integer)((CoreLabel)((Tree)mLeaves.get(mLeaves.size() - 1)).label()).get(CoreAnnotations.IndexAnnotation.class);
            if (",".equals(((CoreLabel)sent.get(endIdx - 1)).word())) {
                --endIdx;
            }
            if (mentionSpanSet.contains(mSpan = new IntPair(beginIdx, endIdx)) || this.lang != Locale.CHINESE && RuleBasedCorefMentionFinder.insideNE(mSpan, namedEntitySpanSet)) continue;
            int dummyMentionId = -1;
            Mention m = new Mention(dummyMentionId, beginIdx, endIdx, sent, basicDependency, collapsedDependency, new ArrayList<CoreLabel>(sent.subList(beginIdx, endIdx)), t);
            mentions.add(m);
            mentionSpanSet.add(mSpan);
        }
    }

    protected static void extractNamedEntityMentions(CoreMap s, List<Mention> mentions, Set<IntPair> mentionSpanSet, Set<IntPair> namedEntitySpanSet) {
        IntPair mSpan;
        List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        SemanticGraph basicDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        SemanticGraph collapsedDependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
        String preNE = "O";
        int beginIndex = -1;
        for (CoreLabel w : sent) {
            String nerString = w.ner();
            if (nerString.equals(preNE)) continue;
            int endIndex = (Integer)w.get(CoreAnnotations.IndexAnnotation.class) - 1;
            if (!preNE.matches("O|QUANTITY|CARDINAL|PERCENT|DATE|DURATION|TIME|SET")) {
                if (((String)w.get(CoreAnnotations.TextAnnotation.class)).equals("'s") && w.tag().equals("POS")) {
                    ++endIndex;
                }
                IntPair mSpan2 = new IntPair(beginIndex, endIndex);
                if (beginIndex < endIndex && !mentionSpanSet.contains(mSpan2)) {
                    int dummyMentionId = -1;
                    Mention m = new Mention(dummyMentionId, beginIndex, endIndex, sent, basicDependency, collapsedDependency, new ArrayList<CoreLabel>(sent.subList(beginIndex, endIndex)));
                    mentions.add(m);
                    mentionSpanSet.add(mSpan2);
                    namedEntitySpanSet.add(mSpan2);
                }
            }
            beginIndex = endIndex;
            preNE = nerString;
        }
        if (!preNE.matches("O|QUANTITY|CARDINAL|PERCENT|DATE|DURATION|TIME|SET") && !mentionSpanSet.contains(mSpan = new IntPair(beginIndex, sent.size()))) {
            int dummyMentionId = -1;
            Mention m = new Mention(dummyMentionId, beginIndex, sent.size(), sent, basicDependency, collapsedDependency, new ArrayList<CoreLabel>(sent.subList(beginIndex, sent.size())));
            mentions.add(m);
            mentionSpanSet.add(mSpan);
            namedEntitySpanSet.add(mSpan);
        }
    }

    @Override
    public void removeSpuriousMentionsEn(Annotation doc, List<List<Mention>> predictedMentions, Dictionaries dict) {
        HashSet standAlones = new HashSet();
        List sentences = (List)doc.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < predictedMentions.size(); ++i) {
            CoreMap s = (CoreMap)sentences.get(i);
            List<Mention> mentions = predictedMentions.get(i);
            Tree tree = (Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class);
            List sent = (List)s.get(CoreAnnotations.TokensAnnotation.class);
            Set<Mention> remove = Generics.newHashSet();
            for (Mention m : mentions) {
                String firstWord;
                String headPOS = (String)m.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                String headNE = (String)m.headWord.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                if (RuleBasedCorefMentionFinder.isPleonastic(m, tree)) {
                    remove.add(m);
                }
                if (dict.nonWords.contains(m.headString)) {
                    remove.add(m);
                }
                if (m.originalSpan.size() > 0 && (firstWord = ((String)m.originalSpan.get(0).get(CoreAnnotations.TextAnnotation.class)).toLowerCase(Locale.ENGLISH)).matches("none|no|nothing|not")) {
                    remove.add(m);
                }
                if (RuleBasedCorefMentionFinder.partitiveRule(m, sent, dict)) {
                    remove.add(m);
                }
                if (headPOS.equals("NN") && !dict.temporals.contains(m.headString) && (m.originalSpan.size() == 1 || ((String)m.originalSpan.get(0).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("JJ"))) {
                    remove.add(m);
                }
                if (m.headString.equals("%")) {
                    remove.add(m);
                }
                if (headNE.equals("PERCENT") || headNE.equals("MONEY")) {
                    remove.add(m);
                }
                if (dict.isAdjectivalDemonym(m.spanToString())) {
                    remove.add(m);
                }
                if (!RuleBasedCorefMentionFinder.inStopList(m)) continue;
                remove.add(m);
            }
            for (Mention m1 : mentions) {
                for (Mention m2 : mentions) {
                    if (m1 == m2 || remove.contains(m1) || remove.contains(m2) || m1.sentNum != m2.sentNum || m1.headWord != m2.headWord || !m2.insideIn(m1) || m2.endIndex < sent.size() && (((String)((CoreLabel)sent.get(m2.endIndex)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals(",") || ((String)((CoreLabel)sent.get(m2.endIndex)).get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("CC"))) continue;
                    remove.add(m2);
                }
            }
            mentions.removeAll(remove);
        }
    }
}

